/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityThrowableCopy;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemKingKey;

public class EntityBabylonWeapon
extends EntityThrowableCopy {
    private static final String TAG_CHARGING = "charging";
    private static final String TAG_VARIETY = "variety";
    private static final String TAG_CHARGE_TICKS = "chargeTicks";
    private static final String TAG_LIVE_TICKS = "liveTicks";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_ROTATION = "rotation";
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIETY = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHARGE_TICKS = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIVE_TICKS = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DELAY = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityBabylonWeapon.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityBabylonWeapon(EntityType<EntityBabylonWeapon> type, World world) {
        super(type, world);
    }

    public EntityBabylonWeapon(LivingEntity thrower, World world) {
        super(ModEntities.BABYLON_WEAPON, thrower, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CHARGING, (Object)false);
        this.field_70180_af.func_187214_a(VARIETY, (Object)0);
        this.field_70180_af.func_187214_a(CHARGE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(LIVE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DELAY, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public boolean func_70112_a(double dist) {
        return dist < 4096.0;
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        boolean charging;
        Entity thrower = this.func_234616_v_();
        if (!(this.field_70170_p.field_72995_K || thrower != null && thrower instanceof PlayerEntity && thrower.func_70089_S())) {
            this.func_70106_y();
            return;
        }
        PlayerEntity player = (PlayerEntity)thrower;
        if (!this.field_70170_p.field_72995_K) {
            boolean newCharging;
            ItemStack stack = PlayerHelper.getFirstHeldItem((LivingEntity)player, ModItems.kingKey);
            boolean bl = newCharging = !stack.func_190926_b() && ItemKingKey.isCharging(stack);
            if (this.isCharging() != newCharging) {
                this.setCharging(newCharging);
            }
        }
        Vector3d mot = this.func_213322_ci();
        int liveTime = this.getLiveTicks();
        int delay = this.getDelay();
        boolean bl = charging = this.isCharging() && liveTime == 0;
        if (charging) {
            this.func_213317_d(Vector3d.field_186680_a);
            int chargeTime = this.getChargeTicks();
            this.setChargeTicks(chargeTime + 1);
            if (this.field_70170_p.field_73012_v.nextInt(20) == 0) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ModSounds.babylonSpawn, SoundCategory.PLAYERS, 0.1f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            }
        } else {
            if (liveTime < delay) {
                this.func_213317_d(Vector3d.field_186680_a);
            } else if (liveTime == delay && player != null) {
                BlockRayTraceResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 64.0, true);
                Vector3d playerLook = rtr.func_216346_c() != RayTraceResult.Type.BLOCK ? player.func_70040_Z().func_186678_a(64.0).func_178787_e(player.func_213303_ch()) : Vector3d.func_237489_a_((Vector3i)rtr.func_216350_a());
                Vector3 thisVec = Vector3.fromEntityCenter((Entity)this);
                mot = playerLook.func_178786_a(thisVec.x, thisVec.y, thisVec.z).func_72432_b().func_186678_a(2.0);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ModSounds.babylonAttack, SoundCategory.PLAYERS, 2.0f, 0.1f + this.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setLiveTicks(liveTime + 1);
                AxisAlignedBB axis = new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70142_S, this.field_70137_T, this.field_70136_U).func_186662_g(2.0);
                List entities = this.field_70170_p.func_217357_a(LivingEntity.class, axis);
                for (LivingEntity living : entities) {
                    if (living == thrower || living.field_70737_aN != 0) continue;
                    if (player != null) {
                        living.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 20.0f);
                    } else {
                        living.func_70097_a(DamageSource.field_76377_j, 20.0f);
                    }
                    this.func_70227_a((RayTraceResult)new EntityRayTraceResult((Entity)living));
                    return;
                }
            }
        }
        super.func_70071_h_();
        this.func_213317_d(mot);
        if (this.field_70170_p.field_72995_K && liveTime > delay) {
            WispParticleData data = WispParticleData.wisp(0.3f, 1.0f, 1.0f, 0.0f, 1.0f);
            this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, -0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && liveTime > 200 + delay) {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult pos) {
        Entity thrower = this.func_234616_v_();
        if (pos.func_216346_c() != RayTraceResult.Type.ENTITY || ((EntityRayTraceResult)pos).func_216348_a() != thrower) {
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.NONE);
            this.func_70106_y();
        }
    }

    public void func_213281_b(@Nonnull CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74757_a(TAG_CHARGING, this.isCharging());
        cmp.func_74768_a(TAG_VARIETY, this.getVariety());
        cmp.func_74768_a(TAG_CHARGE_TICKS, this.getChargeTicks());
        cmp.func_74768_a(TAG_LIVE_TICKS, this.getLiveTicks());
        cmp.func_74768_a(TAG_DELAY, this.getDelay());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
    }

    public void func_70037_a(@Nonnull CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setCharging(cmp.func_74767_n(TAG_CHARGING));
        this.setVariety(cmp.func_74762_e(TAG_VARIETY));
        this.setChargeTicks(cmp.func_74762_e(TAG_CHARGE_TICKS));
        this.setLiveTicks(cmp.func_74762_e(TAG_LIVE_TICKS));
        this.setDelay(cmp.func_74762_e(TAG_DELAY));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)charging);
    }

    public int getVariety() {
        return (Integer)this.field_70180_af.func_187225_a(VARIETY);
    }

    public void setVariety(int var) {
        this.field_70180_af.func_187227_b(VARIETY, (Object)var);
    }

    public int getChargeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(CHARGE_TICKS);
    }

    public void setChargeTicks(int ticks) {
        this.field_70180_af.func_187227_b(CHARGE_TICKS, (Object)ticks);
    }

    public int getLiveTicks() {
        return (Integer)this.field_70180_af.func_187225_a(LIVE_TICKS);
    }

    public void setLiveTicks(int ticks) {
        this.field_70180_af.func_187227_b(LIVE_TICKS, (Object)ticks);
    }

    public int getDelay() {
        return (Integer)this.field_70180_af.func_187225_a(DELAY);
    }

    public void setDelay(int delay) {
        this.field_70180_af.func_187227_b(DELAY, (Object)delay);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }
}

