/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class StateIngredientBlocks
implements StateIngredient {
    protected final ImmutableSet<Block> blocks;

    public StateIngredientBlocks(Collection<Block> blocks) {
        this.blocks = ImmutableSet.copyOf(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains((Object)state.func_177230_c());
    }

    @Override
    public BlockState pick(Random random) {
        return ((Block)this.blocks.asList().get(random.nextInt(this.blocks.size()))).func_176223_P();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "blocks");
        JsonArray array = new JsonArray();
        for (Block block : this.blocks) {
            array.add(Registry.field_212618_g.func_177774_c((Object)block).toString());
        }
        object.add("blocks", (JsonElement)array);
        return object;
    }

    @Override
    public void write(PacketBuffer buffer) {
        List<Block> blocks = this.getBlocks();
        buffer.func_150787_b(0);
        buffer.func_150787_b(blocks.size());
        for (Block block : blocks) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block);
        }
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.blocks.stream().filter(b -> b.func_199767_j() != Items.field_190931_a).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.blocks.stream().map(Block::func_176223_P).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public StateIngredient resolveAndFilter(UnaryOperator<List<Block>> operator) {
        List list = (List)operator.apply(this.getBlocks());
        if (list != null) {
            return list.isEmpty() ? null : StateIngredientHelper.of(list);
        }
        return this;
    }

    @Nonnull
    protected List<Block> getBlocks() {
        return this.blocks.asList();
    }

    public String toString() {
        return "StateIngredientBlocks{" + this.blocks.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.blocks.equals(((StateIngredientBlocks)o).blocks);
    }

    public int hashCode() {
        return Objects.hash(this.blocks);
    }
}

