/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class BrewRecipeProcessor
implements IComponentProcessor {
    private IBrewRecipe recipe;

    public void setup(IVariableProvider variables) {
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        this.recipe = PatchouliUtils.getRecipe(ModRecipeTypes.BREW_TYPE, id);
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            if (key.equals("is_offset")) {
                return IVariable.wrap((Boolean)false);
            }
            return null;
        }
        if (key.equals("heading")) {
            return IVariable.from((Object)new TranslationTextComponent("botaniamisc.brewOf", new Object[]{new TranslationTextComponent(this.recipe.getBrew().getTranslationKey())}));
        }
        if (key.equals("vial")) {
            return IVariable.from((Object)this.recipe.getOutput(new ItemStack((IItemProvider)ModItems.vial)));
        }
        if (key.equals("flask")) {
            return IVariable.from((Object)this.recipe.getOutput(new ItemStack((IItemProvider)ModItems.flask)));
        }
        if (key.startsWith("input")) {
            int indexOffset;
            int requestedIndex = Integer.parseInt(key.substring(5)) - 1;
            int index = requestedIndex - (indexOffset = (6 - this.recipe.func_192400_c().size()) / 2);
            if (index < this.recipe.func_192400_c().size() && index >= 0) {
                return IVariable.wrapList((Iterable)Arrays.stream(((Ingredient)this.recipe.func_192400_c().get(index)).func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            return null;
        }
        if (key.equals("is_offset")) {
            return IVariable.wrap((Boolean)(this.recipe.func_192400_c().size() % 2 == 0 ? 1 : 0));
        }
        return null;
    }
}

