/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.common.block.tile.TileBrewery;

public class ModelBrewery
extends Model {
    private static final ResourceLocation TEXTURE = new ResourceLocation("botania:textures/model/brewery.png");
    final ModelRenderer top;
    final ModelRenderer pole;
    final ModelRenderer bottom;
    final ModelRenderer plate;

    public ModelBrewery() {
        super(RenderType::func_228634_a_);
        this.field_78090_t = 32;
        this.field_78089_u = 16;
        this.top = new ModelRenderer((Model)this, 8, 0);
        this.top.func_78793_a(0.0f, 16.0f, 0.0f);
        this.top.func_228301_a_(-2.0f, -7.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f);
        this.pole = new ModelRenderer((Model)this, 0, 0);
        this.pole.func_78793_a(0.0f, 16.0f, 0.0f);
        this.pole.func_228301_a_(-1.0f, -6.0f, -1.0f, 2.0f, 10.0f, 2.0f, 0.0f);
        this.bottom = new ModelRenderer((Model)this, 8, 5);
        this.bottom.func_78793_a(0.0f, 16.0f, 0.0f);
        this.bottom.func_228301_a_(-2.0f, 4.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f);
        this.plate = new ModelRenderer((Model)this, 8, 5);
        this.plate.func_78793_a(0.0f, 17.0f, 0.0f);
        this.plate.func_228301_a_(5.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f);
    }

    public void render(@Nullable TileBrewery brewery, double time, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        float offset = (float)Math.sin(time / 40.0) * 0.1f + 0.05f;
        boolean hasTile = brewery != null;
        int plates = hasTile ? brewery.inventorySize() - 1 : 7;
        float deg = (float)time / 16.0f;
        float polerot = -deg * 25.0f;
        ms.func_227861_a_(0.0, (double)offset, 0.0);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(polerot));
        if (hasTile && !brewery.getItemHandler().func_70301_a(0).func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            ms.func_227861_a_(0.0, (double)-0.45f, 0.0);
            this.renderItemStack(brewery.getItemHandler().func_70301_a(0), ms, buffers, light, overlay);
            ms.func_227865_b_();
        }
        RenderType layer = this.func_228282_a_(TEXTURE);
        this.pole.func_228308_a_(ms, buffers.getBuffer(layer), light, overlay);
        this.top.func_228308_a_(ms, buffers.getBuffer(layer), light, overlay);
        this.bottom.func_228308_a_(ms, buffers.getBuffer(layer), light, overlay);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-polerot));
        float degper = (float)Math.PI * 2 / (float)plates;
        for (int i = 0; i < plates; ++i) {
            this.plate.field_78796_g = deg;
            float offset1 = (float)Math.sin(time / 20.0 + (double)((float)i * 40.0f)) * 0.2f - 0.2f;
            if (time == -1.0) {
                offset1 = 0.0f;
            }
            ms.func_227861_a_(0.0, (double)offset1, 0.0);
            if (hasTile && !brewery.getItemHandler().func_70301_a(i + 1).func_190926_b()) {
                float rot = this.plate.field_78796_g * 180.0f / (float)Math.PI;
                float transX = 0.3125f;
                float transY = 1.06f;
                float transZ = 0.1245f;
                ms.func_227860_a_();
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot));
                ms.func_227861_a_((double)transX, (double)transY, (double)transZ);
                ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                ms.func_227861_a_(0.125, 0.125, 0.0);
                this.renderItemStack(brewery.getItemHandler().func_70301_a(i + 1), ms, buffers, light, overlay);
                ms.func_227865_b_();
            }
            this.plate.func_228308_a_(ms, buffers.getBuffer(layer), light, overlay);
            ms.func_227861_a_(0.0, (double)(-offset1), 0.0);
            deg += degper;
        }
        ms.func_227861_a_(0.0, (double)(-offset), 0.0);
    }

    private void renderItemStack(ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        if (!stack.func_190926_b()) {
            Minecraft mc = Minecraft.func_71410_x();
            ms.func_227860_a_();
            float s = 0.25f;
            ms.func_227862_a_(s, s, s);
            mc.func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, ms, buffers);
            ms.func_227865_b_();
        }
    }

    public void func_225598_a_(MatrixStack ms, IVertexBuilder buffer, int light, int overlay, float r, float g, float b, float a) {
        throw new UnsupportedOperationException("unimplemented, call using other render method");
    }
}

