/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Matrix4f;
import vazkii.botania.client.fx.FXLightningSegment;
import vazkii.botania.client.fx.LightningSegmentGenerator;
import vazkii.botania.common.core.helper.Vector3;

public class FXLightning
extends Particle {
    private static final int fadetime = 20;
    private final int expandTime;
    private final int colorOuter;
    private final int colorInner;
    private final List<FXLightningSegment> segments;
    private final int segmentCount;
    private static final IParticleRenderType LAYER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder buffer, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableTexture();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227852_q_);
        }

        public void func_217599_a(Tessellator tess) {
            tess.func_78381_a();
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    };

    public FXLightning(ClientWorld world, Vector3 sourcevec, Vector3 targetvec, float speed, long seed, int colorOuter, int colorInner) {
        super(world, sourcevec.x, sourcevec.y, sourcevec.z);
        this.colorOuter = colorOuter;
        this.colorInner = colorInner;
        double length = targetvec.subtract(sourcevec).mag();
        this.field_70547_e = 20 + world.field_73012_v.nextInt(20) - 10;
        this.expandTime = (int)(length * (double)speed);
        this.field_70546_d = -((int)(length * (double)speed));
        LightningSegmentGenerator gen = new LightningSegmentGenerator(seed);
        Pair<Integer, List<FXLightningSegment>> res = gen.compute(sourcevec, targetvec, length);
        this.segmentCount = (Integer)res.getFirst();
        this.segments = (List)res.getSecond();
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo info, float partialTicks) {
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return LAYER;
    }

    public void renderBolt(MatrixStack ms, IVertexBuilder wr, int pass, boolean inner) {
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        float boltAge = this.field_70546_d < 0 ? 0.0f : (float)this.field_70546_d / (float)this.field_70547_e;
        float mainAlpha = pass == 0 ? (1.0f - boltAge) * 0.4f : 1.0f - boltAge * 0.5f;
        int renderstart = (int)((float)(this.expandTime / 2 - this.field_70547_e + this.field_70546_d) / (float)(this.expandTime / 2) * (float)this.segmentCount);
        int renderend = (int)((float)(this.field_70546_d + this.expandTime) / (float)this.expandTime * (float)this.segmentCount);
        for (FXLightningSegment rendersegment : this.segments) {
            Vector3 roundend;
            if (rendersegment.segmentNo < renderstart || rendersegment.segmentNo > renderend) continue;
            Vector3 playerVec = FXLightning.getRelativeViewVector(rendersegment.startPoint.point).multiply(-1.0);
            double width = (double)0.025f * (playerVec.mag() / 5.0 + 1.0) * (double)(1.0f + rendersegment.light) * 0.5;
            Vector3 diff1 = playerVec.crossProduct(rendersegment.prevDiff).normalize().multiply(width / (double)rendersegment.sinPrev);
            Vector3 diff2 = playerVec.crossProduct(rendersegment.nextDiff).normalize().multiply(width / (double)rendersegment.sinNext);
            Vector3 startvec = rendersegment.startPoint.point;
            Vector3 endvec = rendersegment.endPoint.point;
            int color = inner ? this.colorInner : this.colorOuter;
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            int a = (int)(mainAlpha * rendersegment.light * 255.0f);
            int fullbright = 0xF000F0;
            endvec.subtract(diff2).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.0f).func_227886_a_(fullbright).func_181675_d();
            startvec.subtract(diff1).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.0f).func_227886_a_(fullbright).func_181675_d();
            startvec.add(diff1).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227886_a_(fullbright).func_181675_d();
            endvec.add(diff2).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227886_a_(fullbright).func_181675_d();
            if (rendersegment.next == null) {
                roundend = rendersegment.endPoint.point.add(rendersegment.diff.normalize().multiply(width));
                roundend.subtract(diff2).vertex(mat, wr);
                wr.func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227886_a_(fullbright).func_181675_d();
                endvec.subtract(diff2).vertex(mat, wr);
                wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.0f).func_227886_a_(fullbright).func_181675_d();
                endvec.add(diff2).vertex(mat, wr);
                wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227886_a_(fullbright).func_181675_d();
                roundend.add(diff2).vertex(mat, wr);
                wr.func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227886_a_(fullbright).func_181675_d();
            }
            if (rendersegment.prev != null) continue;
            roundend = rendersegment.startPoint.point.subtract(rendersegment.diff.normalize().multiply(width));
            startvec.subtract(diff1).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 0.0f).func_227886_a_(fullbright).func_181675_d();
            roundend.subtract(diff1).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227886_a_(fullbright).func_181675_d();
            roundend.add(diff1).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227886_a_(fullbright).func_181675_d();
            startvec.add(diff1).vertex(mat, wr);
            wr.func_225586_a_(r, g, b, a).func_225583_a_(0.5f, 1.0f).func_227886_a_(fullbright).func_181675_d();
        }
    }

    private static Vector3 getRelativeViewVector(Vector3 pos) {
        Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
        return new Vector3((double)((float)renderEntity.func_226277_ct_()) - pos.x, (double)((float)renderEntity.func_226278_cu_()) - pos.y, (double)((float)renderEntity.func_226281_cx_()) - pos.z);
    }
}

