/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.OptifineHandler;
import com.jozufozu.flywheel.config.BooleanDirective;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.config.SConfigureBooleanPacket;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum BooleanConfig {
    ENGINE(() -> BooleanConfig::enabled),
    NORMAL_OVERLAY(() -> BooleanConfig::normalOverlay);

    final Supplier<Consumer<BooleanDirective>> receiver;

    private BooleanConfig(Supplier<Consumer<BooleanDirective>> receiver) {
        this.receiver = receiver;
    }

    public SConfigureBooleanPacket packet(BooleanDirective directive) {
        return new SConfigureBooleanPacket(this, directive);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeByte(this.ordinal());
    }

    public static BooleanConfig decode(PacketBuffer buffer) {
        byte t = buffer.readByte();
        BooleanConfig[] values = BooleanConfig.values();
        if (t >= 0 && t < values.length) {
            return values[t];
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void enabled(BooleanDirective state) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || state == null) {
            return;
        }
        if (state == BooleanDirective.DISPLAY) {
            IFormattableTextComponent text = new StringTextComponent("Flywheel renderer is currently: ").func_230529_a_((ITextComponent)BooleanConfig.boolToText((Boolean)FlwConfig.get().client.enabled.get()));
            player.func_146105_b((ITextComponent)text, false);
            return;
        }
        boolean enabled = state.get();
        boolean cannotUse = OptifineHandler.usingShaders() && enabled;
        FlwConfig.get().client.enabled.set((Object)enabled);
        IFormattableTextComponent text = BooleanConfig.boolToText((Boolean)FlwConfig.get().client.enabled.get()).func_230529_a_((ITextComponent)new StringTextComponent(" Flywheel renderer").func_240699_a_(TextFormatting.WHITE));
        IFormattableTextComponent error = new StringTextComponent("Flywheel renderer does not support Optifine Shaders").func_240699_a_(TextFormatting.RED);
        player.func_146105_b((ITextComponent)(cannotUse ? error : text), false);
        Backend.reloadWorldRenderers();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void normalOverlay(BooleanDirective state) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || state == null) {
            return;
        }
        if (state == BooleanDirective.DISPLAY) {
            IFormattableTextComponent text = new StringTextComponent("Normal debug mode is currently: ").func_230529_a_((ITextComponent)BooleanConfig.boolToText((Boolean)FlwConfig.get().client.debugNormals.get()));
            player.func_146105_b((ITextComponent)text, false);
            return;
        }
        FlwConfig.get().client.debugNormals.set((Object)state.get());
        IFormattableTextComponent text = BooleanConfig.boolToText((Boolean)FlwConfig.get().client.debugNormals.get()).func_230529_a_((ITextComponent)new StringTextComponent(" normal debug mode").func_240699_a_(TextFormatting.WHITE));
        player.func_146105_b((ITextComponent)text, false);
    }

    private static IFormattableTextComponent boolToText(boolean b) {
        return b ? new StringTextComponent("enabled").func_240699_a_(TextFormatting.DARK_GREEN) : new StringTextComponent("disabled").func_240699_a_(TextFormatting.RED);
    }
}

