/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.loading;

import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.loading.ShaderLoadingException;
import com.jozufozu.flywheel.backend.loading.TaggedStruct;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public class Shader {
    private static final Pattern includePattern = Pattern.compile("#flwinclude <\"([\\w\\d_]+:[\\w\\d_./]+)\">");
    public static final Pattern versionDetector = Pattern.compile("#version[^\\n]*");
    private static final Pattern decorator = Pattern.compile("#\\[([\\w_]*)]");
    public final ResourceLocation name;
    public ShaderType type;
    private String source;
    private final ShaderSources loader;
    private boolean parsed = false;
    final List<TaggedStruct> structs = new ArrayList<TaggedStruct>(3);
    final Map<String, TaggedStruct> tag2Struct = new HashMap<String, TaggedStruct>();
    final Map<String, TaggedStruct> name2Struct = new HashMap<String, TaggedStruct>();

    public Shader(ShaderSources loader, ShaderType type, ResourceLocation name, String source) {
        this.loader = loader;
        this.type = type;
        this.name = name;
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public TaggedStruct getTag(String tag) {
        this.checkIfParsed();
        return this.tag2Struct.get(tag);
    }

    public TaggedStruct getStruct(String name) {
        this.checkIfParsed();
        return this.name2Struct.get(name);
    }

    private void checkIfParsed() {
        if (!this.parsed) {
            throw new IllegalStateException("tagged structs must be explicitly parsed before use");
        }
    }

    public void defineAll(Collection<String> defines) {
        Matcher matcher = versionDetector.matcher(this.source);
        if (matcher.find()) {
            StringBuffer sourceWithDefines = new StringBuffer();
            String lines = defines.stream().map(it -> "#define " + it).collect(Collectors.joining("\n"));
            matcher.appendReplacement(sourceWithDefines, matcher.group() + '\n' + lines);
            matcher.appendTail(sourceWithDefines);
            this.source = sourceWithDefines.toString();
        }
    }

    public void parseStructs() {
        Matcher structMatcher = TaggedStruct.taggedStruct.matcher(this.source);
        StringBuffer strippedSrc = new StringBuffer();
        while (structMatcher.find()) {
            TaggedStruct struct = new TaggedStruct(structMatcher);
            this.structs.add(struct);
            String replacement = decorator.matcher(struct.source).replaceFirst("");
            structMatcher.appendReplacement(strippedSrc, replacement);
            this.tag2Struct.put(struct.tag, struct);
            this.name2Struct.put(struct.name, struct);
        }
        structMatcher.appendTail(strippedSrc);
        this.source = strippedSrc.toString();
        this.parsed = true;
    }

    public void processIncludes() {
        HashSet<ResourceLocation> seen = new HashSet<ResourceLocation>();
        seen.add(this.name);
        this.source = this.includeRecursive(this.source, seen).collect(Collectors.joining("\n"));
    }

    private Stream<String> includeRecursive(String source, Set<ResourceLocation> seen) {
        return Shader.lines(source).flatMap(line -> {
            String includeName;
            ResourceLocation include;
            Matcher matcher = includePattern.matcher((CharSequence)line);
            if (matcher.find() && seen.add(include = new ResourceLocation(includeName = matcher.group(1)))) {
                try {
                    return this.includeRecursive(this.loader.getShaderSource(include), seen);
                }
                catch (ShaderLoadingException e) {
                    throw new ShaderLoadingException("could not resolve import: " + e.getMessage());
                }
            }
            return Stream.of(line);
        });
    }

    public String printSource() {
        StringBuilder builder = new StringBuilder();
        builder.append("Source for shader '").append(this.name).append("':\n");
        int i = 1;
        for (String s : this.source.split("\n")) {
            builder.append(String.format("%1$4s: ", i++)).append(s).append('\n');
        }
        return builder.toString();
    }

    public static Stream<String> lines(String s) {
        return new BufferedReader(new StringReader(s)).lines();
    }
}

