/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.shader;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.util.RenderUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL20;

public abstract class GlProgram
extends GlObject {
    public final ResourceLocation name;

    protected GlProgram(Program program) {
        this.setHandle(program.program);
        this.name = program.name;
    }

    public void bind() {
        GL20.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public int getUniformLocation(String uniform) {
        int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)uniform);
        if (index < 0) {
            Backend.log.debug("No active uniform '{}' exists in program '{}'. Could be unused.", (Object)uniform, (Object)this.name);
        }
        return index;
    }

    public int setSamplerBinding(String name, int binding) {
        int samplerUniform = this.getUniformLocation(name);
        if (samplerUniform >= 0) {
            GL20.glUniform1i((int)samplerUniform, (int)binding);
        }
        return samplerUniform;
    }

    protected static void uploadMatrixUniform(int uniform, Matrix4f mat) {
        GL20.glUniformMatrix4fv((int)uniform, (boolean)false, (float[])RenderUtil.writeMatrix(mat));
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteProgram((int)handle);
    }

    public String toString() {
        return "program " + this.name;
    }
}

