/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.IFlywheelWorld;
import com.jozufozu.flywheel.backend.IShaderContext;
import com.jozufozu.flywheel.backend.OptifineHandler;
import com.jozufozu.flywheel.backend.RenderWork;
import com.jozufozu.flywheel.backend.ShaderContext;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.SpecMetaRegistry;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.material.MaterialSpec;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;

public class Backend {
    public static final Logger log = LogManager.getLogger(Backend.class);
    protected static final Backend INSTANCE = new Backend();
    public final Minecraft minecraft;
    public ShaderSources sources;
    public GLCapabilities capabilities;
    public GlCompat compat;
    private Matrix4f projectionMatrix = new Matrix4f();
    private boolean instancedArrays;
    private boolean enabled;
    private final List<IShaderContext<?>> contexts = new ArrayList();
    private final Map<ResourceLocation, MaterialSpec<?>> materialRegistry = new HashMap();
    private final Map<ResourceLocation, ProgramSpec> programSpecRegistry = new HashMap<ResourceLocation, ProgramSpec>();

    public static Backend getInstance() {
        return INSTANCE;
    }

    protected Backend() {
        this.minecraft = Minecraft.func_71410_x();
        if (this.minecraft == null) {
            return;
        }
        this.sources = new ShaderSources(this);
        OptifineHandler.init();
    }

    void clearContexts() {
        SpecMetaRegistry.clear();
        this.programSpecRegistry.clear();
        this.contexts.forEach(IShaderContext::delete);
        this.contexts.clear();
        this.materialRegistry.clear();
    }

    public String getBackendDescriptor() {
        if (this.canUseInstancing()) {
            return "GL33 Instanced Arrays";
        }
        if (this.canUseVBOs()) {
            return "VBOs";
        }
        return "Disabled";
    }

    public ProgramSpec register(ProgramSpec spec) {
        ResourceLocation name = spec.name;
        if (this.programSpecRegistry.containsKey(name)) {
            throw new IllegalStateException("Program spec '" + name + "' already registered.");
        }
        this.programSpecRegistry.put(name, spec);
        return spec;
    }

    public <C extends ShaderContext<?>> C register(C spec) {
        this.contexts.add(spec);
        return spec;
    }

    public <D extends InstanceData> MaterialSpec<D> register(MaterialSpec<D> spec) {
        ResourceLocation name = spec.name;
        if (this.materialRegistry.containsKey(name)) {
            throw new IllegalStateException("Material spec '" + name + "' already registered.");
        }
        this.materialRegistry.put(name, spec);
        log.debug("registered material '" + name + "' with vertex size " + spec.getModelFormat().getStride() + " and instance size " + spec.getInstanceFormat().getStride());
        return spec;
    }

    public ProgramSpec getSpec(ResourceLocation name) {
        return this.programSpecRegistry.get(name);
    }

    public boolean available() {
        return this.canUseVBOs();
    }

    public boolean canUseInstancing() {
        return this.enabled && this.instancedArrays;
    }

    public boolean canUseVBOs() {
        return this.enabled && this.gl20();
    }

    public boolean gl33() {
        return this.capabilities.OpenGL33;
    }

    public boolean gl20() {
        return this.capabilities.OpenGL20;
    }

    public void refresh() {
        OptifineHandler.refresh();
        this.capabilities = GL.createCapabilities();
        this.compat = new GlCompat(this.capabilities);
        this.instancedArrays = this.compat.vertexArrayObjectsSupported() && this.compat.drawInstancedSupported() && this.compat.instancedArraysSupported();
        this.enabled = FlwConfig.get().enabled() && !OptifineHandler.usingShaders();
    }

    public boolean canUseInstancing(@Nullable World world) {
        return this.canUseInstancing() && Backend.isFlywheelWorld((IWorld)world);
    }

    public Collection<MaterialSpec<?>> allMaterials() {
        return this.materialRegistry.values();
    }

    public Collection<ProgramSpec> allPrograms() {
        return this.programSpecRegistry.values();
    }

    public Collection<IShaderContext<?>> allContexts() {
        return this.contexts;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public void setProjectionMatrix(Matrix4f projectionMatrix) {
        this.projectionMatrix = projectionMatrix;
    }

    public static boolean isFlywheelWorld(@Nullable IWorld world) {
        if (world == null) {
            return false;
        }
        if (world instanceof IFlywheelWorld && ((IFlywheelWorld)world).supportsFlywheel()) {
            return true;
        }
        return world == Minecraft.func_71410_x().field_71441_e;
    }

    public static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }

    public static void reloadWorldRenderers() {
        RenderWork.enqueue(() -> ((WorldRenderer)Minecraft.func_71410_x().field_71438_f).func_72712_a());
    }

    public static void init() {
    }
}

