/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GeneratorFuelSerializer
extends IERecipeSerializer<GeneratorFuel> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.dieselGenerator);
    }

    @Override
    public GeneratorFuel readFromJson(ResourceLocation recipeId, JsonObject json) {
        ResourceLocation tagName = new ResourceLocation(json.get("fluidTag").getAsString());
        ITag tag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(tagName);
        int amount = json.get("burnTime").getAsInt();
        return new GeneratorFuel(recipeId, (ITag<Fluid>)tag, amount);
    }

    @Nullable
    public GeneratorFuel fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        List<Fluid> fluids = PacketUtils.readList(buffer, buf -> (Fluid)buf.readRegistryIdUnsafe(ForgeRegistries.FLUIDS));
        int burnTime = buffer.readInt();
        return new GeneratorFuel(recipeId, fluids, burnTime);
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull GeneratorFuel recipe) {
        PacketUtils.writeList(buffer, recipe.getFluids(), (f, buf) -> buf.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)f));
        buffer.writeInt(recipe.getBurnTime());
    }
}

