/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingChecker;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class ArcRecyclingCalculator {
    private static List<ArcFurnaceRecipe> lastResult;
    private final List<IRecipe<?>> recipeList;
    private final long startTime = System.currentTimeMillis();
    private final ArcRecyclingChecker checker;

    public ArcRecyclingCalculator(Collection<IRecipe<?>> allRecipes) {
        Pair<Predicate<IRecipe<?>>, ArcRecyclingChecker> pair = ArcRecyclingChecker.assembleRecyclingFilter();
        this.checker = (ArcRecyclingChecker)pair.getRight();
        this.recipeList = allRecipes.stream().filter((Predicate)pair.getLeft()).collect(Collectors.toList());
    }

    public void run() {
        RecipeIterator iterator = new RecipeIterator(this.recipeList, this.checker);
        iterator.process();
        int timeout = 0;
        while (!iterator.nonValidated.isEmpty() && timeout++ < iterator.invalidCount * 10) {
            ArrayList<RecyclingCalculation> newlyValid = new ArrayList<RecyclingCalculation>();
            for (RecyclingCalculation valid : iterator.validated) {
                for (ItemStack key : iterator.nonValidated.keySet()) {
                    if (!ItemStack.func_179545_c((ItemStack)key, (ItemStack)valid.stack)) continue;
                    for (RecyclingCalculation nonValid : iterator.nonValidated.get((Object)key)) {
                        if (!nonValid.validateSubcomponent(valid)) continue;
                        newlyValid.add(nonValid);
                    }
                }
            }
            if (newlyValid.isEmpty()) break;
            iterator.nonValidated.values().removeAll(newlyValid);
            iterator.validated.addAll(newlyValid);
        }
        ArrayList<ArcFurnaceRecipe> generatedRecipes = new ArrayList<ArcFurnaceRecipe>();
        HashSet<String> finishedRecycles = new HashSet<String>();
        for (RecyclingCalculation valid : iterator.validated) {
            if (!finishedRecycles.add(valid.stack.toString()) || valid.outputs.isEmpty()) continue;
            generatedRecipes.add(this.makeRecipe(valid));
        }
        for (RecyclingCalculation invalid : Sets.newHashSet((Iterable)iterator.nonValidated.values())) {
            if (!finishedRecycles.add(invalid.stack.toString()) || invalid.outputs.isEmpty()) continue;
            IELogger.info("Couldn't fully analyze " + invalid.stack + ", missing knowledge for " + invalid.queriedSubcomponents);
            generatedRecipes.add(this.makeRecipe(invalid));
        }
        lastResult = generatedRecipes;
        IELogger.info("Finished recipe profiler for Arc Recycling, took " + (System.currentTimeMillis() - this.startTime) + " milliseconds");
    }

    private ArcRecyclingRecipe makeRecipe(RecyclingCalculation calculation) {
        ResourceLocation id = new ResourceLocation("immersiveengineering", "recycling/" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)calculation.stack.func_77973_b()).func_110623_a());
        return new ArcRecyclingRecipe(id, calculation.outputs, IngredientWithSize.of(calculation.stack), 100, 51200);
    }

    public static List<ArcFurnaceRecipe> getRecipesFromRunningThreads() {
        return Objects.requireNonNull(lastResult);
    }

    private static class RecipeIterator {
        final List<IRecipe<?>> recipeList;
        final List<RecyclingCalculation> validated = new ArrayList<RecyclingCalculation>();
        final Multimap<ItemStack, RecyclingCalculation> nonValidated = ArrayListMultimap.create();
        private final ArcRecyclingChecker checker;
        int invalidCount = 0;

        public RecipeIterator(List<IRecipe<?>> recipeList, ArcRecyclingChecker checker) {
            this.recipeList = recipeList;
            this.checker = checker;
        }

        public void process() {
            for (IRecipe<?> recipe : this.recipeList) {
                RecyclingCalculation calc = this.getRecycleCalculation(recipe.func_77571_b(), recipe);
                if (calc == null) continue;
                if (calc.isValid()) {
                    this.validated.add(calc);
                    continue;
                }
                for (ItemStack s : calc.queriedSubcomponents.keySet()) {
                    this.nonValidated.put((Object)s, (Object)calc);
                }
                ++this.invalidCount;
            }
        }

        private RecyclingCalculation getRecycleCalculation(ItemStack stack, IRecipe<?> recipe) {
            Pair<ItemStack, Double> brokenDown = ApiUtils.breakStackIntoPreciseIngots(stack);
            if (brokenDown != null && ArcRecyclingChecker.isValidRecyclingOutput((ItemStack)brokenDown.getLeft()) && (Double)brokenDown.getRight() > 0.0) {
                return new RecyclingCalculation(recipe, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), (Map<ItemStack, Double>)ImmutableMap.of((Object)((ItemStack)brokenDown.getLeft()), (Object)((Double)brokenDown.getRight())));
            }
            NonNullList inputs = recipe.func_192400_c();
            if (!inputs.isEmpty()) {
                int resultCount = stack.func_190916_E();
                HashMap<ItemStack, Integer> missingSub = new HashMap<ItemStack, Integer>();
                IdentityHashMap<ItemStack, Double> outputs = new IdentityHashMap<ItemStack, Double>();
                for (Object in : inputs) {
                    boolean invalidOutput;
                    if (in == null || in == Ingredient.field_193370_a) continue;
                    ItemStack[] itemStackArray = in.func_193365_a();
                    ItemStack inputStack = ItemStack.field_190927_a;
                    if (itemStackArray.length > 0) {
                        inputStack = IEApi.getPreferredStackbyMod(in.func_193365_a());
                    }
                    if (inputStack.func_190926_b()) {
                        IELogger.warn("Recipe has invalid inputs and will be ignored: " + recipe + " (" + recipe.func_199560_c() + ")");
                        return null;
                    }
                    brokenDown = ApiUtils.breakStackIntoPreciseIngots(inputStack);
                    if (brokenDown == null) {
                        if (!this.checker.isAllowed(inputStack) || !ArcRecyclingChecker.isValidRecyclingOutput(inputStack)) continue;
                        boolean b = false;
                        for (ItemStack storedMiss : missingSub.keySet()) {
                            if (!ItemStack.func_179545_c((ItemStack)inputStack, (ItemStack)storedMiss)) continue;
                            missingSub.put(storedMiss, (Integer)missingSub.get(storedMiss) + inputStack.func_190916_E());
                            b = true;
                        }
                        if (b) continue;
                        missingSub.put(ItemHandlerHelper.copyStackWithSize((ItemStack)inputStack, (int)1), inputStack.func_190916_E());
                        continue;
                    }
                    if (((ItemStack)brokenDown.getLeft()).func_190926_b() || !((Double)brokenDown.getRight() > 0.0) || (invalidOutput = !ArcRecyclingChecker.isValidRecyclingOutput((ItemStack)brokenDown.getLeft()))) continue;
                    boolean b = false;
                    for (ItemStack storedOut : outputs.keySet()) {
                        if (!ItemStack.func_179545_c((ItemStack)((ItemStack)brokenDown.getLeft()), (ItemStack)storedOut)) continue;
                        outputs.put(storedOut, (Double)outputs.get(storedOut) + (Double)brokenDown.getRight());
                        b = true;
                    }
                    if (b) continue;
                    outputs.put(ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)brokenDown.getLeft()), (int)1), (Double)brokenDown.getRight());
                }
                IdentityHashMap<ItemStack, Double> outputScaled = new IdentityHashMap<ItemStack, Double>(outputs.size());
                for (Map.Entry entry : outputs.entrySet()) {
                    outputScaled.put((ItemStack)entry.getKey(), (Double)entry.getValue() / (double)resultCount);
                }
                if (!outputs.isEmpty() || !missingSub.isEmpty()) {
                    Object in;
                    in = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                    RecyclingCalculation recyclingCalculation = new RecyclingCalculation(recipe, (ItemStack)in, outputScaled);
                    if (!missingSub.isEmpty()) {
                        for (ItemStack s : missingSub.keySet()) {
                            recyclingCalculation.queriedSubcomponents.put(s, (double)((Integer)missingSub.get(s)).intValue() / (double)resultCount);
                        }
                    }
                    return recyclingCalculation;
                }
            }
            return null;
        }
    }

    private static class RecyclingCalculation {
        IRecipe<?> recipe;
        ItemStack stack;
        Map<ItemStack, Double> outputs;
        Map<ItemStack, Double> queriedSubcomponents = new HashMap<ItemStack, Double>();

        public RecyclingCalculation(IRecipe<?> recipe, ItemStack stack, Map<ItemStack, Double> outputs) {
            this.recipe = recipe;
            this.stack = stack;
            this.outputs = outputs;
        }

        public boolean isValid() {
            return !this.outputs.isEmpty() && this.queriedSubcomponents.isEmpty();
        }

        public boolean validateSubcomponent(RecyclingCalculation calc) {
            if (this.isValid()) {
                return true;
            }
            if (!calc.isValid()) {
                return false;
            }
            Iterator<ItemStack> it = this.queriedSubcomponents.keySet().iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!ItemStack.func_179545_c((ItemStack)next, (ItemStack)calc.stack)) continue;
                double queriedAmount = this.queriedSubcomponents.get(next);
                for (Map.Entry<ItemStack, Double> e : calc.outputs.entrySet()) {
                    double scaledVal = e.getValue() * queriedAmount;
                    boolean b = true;
                    for (ItemStack key : this.outputs.keySet()) {
                        if (!ItemStack.func_179545_c((ItemStack)key, (ItemStack)e.getKey())) continue;
                        this.outputs.put(key, this.outputs.get(key) + scaledVal);
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    this.outputs.put(e.getKey(), scaledVal);
                }
                it.remove();
            }
            return this.isValid();
        }
    }
}

