/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class SmartLightingQuad
extends BakedQuad {
    private static Field parent;
    private static Field blockInfo;
    private static Field pose;
    BlockPos blockPos;

    public SmartLightingQuad(int[] vertexDataIn, int tintIndexIn, Direction faceIn, TextureAtlasSprite spriteIn, BlockPos p) {
        super(vertexDataIn, tintIndexIn, faceIn, spriteIn, false);
        this.blockPos = p;
    }

    public void pipe(IVertexConsumer consumer) {
        if (consumer instanceof VertexLighterFlat) {
            super.pipe((IVertexConsumer)new SmartVertexLighter((VertexLighterFlat)consumer));
        } else {
            super.pipe(consumer);
        }
    }

    static {
        try {
            blockInfo = VertexLighterFlat.class.getDeclaredField("blockInfo");
            blockInfo.setAccessible(true);
            pose = VertexLighterFlat.class.getDeclaredField("pose");
            pose.setAccessible(true);
            parent = QuadGatheringTransformer.class.getDeclaredField("parent");
            parent.setAccessible(true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private class SmartVertexLighter
    extends VertexLighterFlat {
        private byte oldLightmapLength;

        public SmartVertexLighter(VertexLighterFlat base) {
            super(Minecraft.func_71410_x().func_184125_al());
            try {
                this.setParent((IVertexConsumer)parent.get(base));
                this.setTransform((MatrixStack.Entry)pose.get(base));
                this.setVertexFormat(DefaultVertexFormats.field_176600_a);
                BlockInfo info = (BlockInfo)blockInfo.get(base);
                this.setWorld(info.getWorld());
                this.setState(info.getState());
                this.setBlockPos(info.getBlockPos());
                this.updateBlockInfo();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
            IBlockDisplayReader world = this.blockInfo.getWorld();
            BlockPos here = SmartLightingQuad.this.blockPos.func_177963_a(Math.floor((double)(x - normal[0] / 2.0f) + 0.5), Math.floor((double)(y - normal[1] / 2.0f) + 0.5), Math.floor((double)(z - normal[2] / 2.0f) + 0.5));
            lightmap[0] = (float)world.func_225524_e_().func_215569_a(LightType.BLOCK).func_215611_b(here) / 15.0f;
            lightmap[1] = (float)world.func_225524_e_().func_215569_a(LightType.SKY).func_215611_b(here) / 15.0f;
            this.oldLightmapLength = this.dataLength[this.lightmapIndex];
            this.dataLength[this.lightmapIndex] = 0;
        }

        protected void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
            this.dataLength[this.lightmapIndex] = this.oldLightmapLength;
            super.updateColor(normal, color, x, y, z, tint, multiplier);
        }
    }
}

