/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.redstone;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneNetworkHandler
extends LocalNetworkHandler
implements IWorldTickable {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "redstone");
    private byte[] totalValues = new byte[16];
    private final Map<ConnectionPoint, byte[]> emittedValues = new HashMap<ConnectionPoint, byte[]>();
    private boolean updateNextTick = false;

    public RedstoneNetworkHandler(LocalWireNetwork local, GlobalWireNetwork global) {
        super(local, global);
    }

    @Override
    public void update(World w) {
        if (this.updateNextTick) {
            this.updateValues();
            this.updateNextTick = false;
        }
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        if (!(other instanceof RedstoneNetworkHandler)) {
            return new RedstoneNetworkHandler(this.localNet, this.globalNet);
        }
        RedstoneNetworkHandler otherRS = (RedstoneNetworkHandler)other;
        RedstoneNetworkHandler ret = new RedstoneNetworkHandler(this.localNet, this.globalNet);
        RedstoneNetworkHandler.fillWithMax(this.totalValues, otherRS.totalValues, ret.totalValues);
        ret.emittedValues.putAll(this.emittedValues);
        ret.emittedValues.putAll(otherRS.emittedValues);
        return ret;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint newCP, IImmersiveConnectable iic) {
        if (!(iic instanceof IRedstoneConnector)) {
            return;
        }
        this.localNet.addAsFutureTask(() -> {
            IRedstoneConnector rsConn = (IRedstoneConnector)iic;
            byte[] emitted = RedstoneNetworkHandler.getEmitted(rsConn, newCP);
            RedstoneNetworkHandler.fillWithMax(emitted, this.totalValues, this.totalValues);
            this.emittedValues.put(newCP, emitted);
            for (ConnectionPoint cp : this.localNet.getConnectionPoints()) {
                IImmersiveConnectable here = this.localNet.getConnector(cp);
                if (!(here instanceof IRedstoneConnector)) continue;
                ((IRedstoneConnector)here).onChange(cp, this);
            }
        });
    }

    public void updateValues() {
        IImmersiveConnectable here;
        this.totalValues = new byte[16];
        this.emittedValues.clear();
        for (ConnectionPoint cp : this.localNet.getConnectionPoints()) {
            here = this.localNet.getConnector(cp);
            if (!(here instanceof IRedstoneConnector)) continue;
            byte[] output = RedstoneNetworkHandler.getEmitted((IRedstoneConnector)here, cp);
            this.emittedValues.put(cp, output);
            RedstoneNetworkHandler.fillWithMax(output, this.totalValues, this.totalValues);
        }
        for (ConnectionPoint cp : this.localNet.getConnectionPoints()) {
            here = this.localNet.getConnector(cp);
            if (!(here instanceof IRedstoneConnector)) continue;
            ((IRedstoneConnector)here).onChange(cp, this);
        }
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.updateNextTick = true;
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.updateNextTick = true;
    }

    @Override
    public void onConnectionAdded(Connection c) {
    }

    @Override
    public void onConnectionRemoved(Connection c) {
    }

    @Override
    public void setLocalNet(LocalWireNetwork net) {
        super.setLocalNet(net);
        for (ConnectionPoint cp : net.getConnectionPoints()) {
            IImmersiveConnectable here = net.getConnector(cp);
            if (!(here instanceof IRedstoneConnector)) continue;
            ((IRedstoneConnector)here).onChange(cp, this);
        }
    }

    public byte getValue(int redstoneChannel) {
        return this.totalValues[redstoneChannel];
    }

    public byte[] getValuesExcluding(ConnectionPoint excluded) {
        byte[] ret = new byte[16];
        for (Map.Entry<ConnectionPoint, byte[]> entry : this.emittedValues.entrySet()) {
            if (entry.getKey().equals(excluded)) continue;
            RedstoneNetworkHandler.fillWithMax(entry.getValue(), ret, ret);
        }
        return ret;
    }

    private static byte[] getEmitted(IRedstoneConnector connector, ConnectionPoint cp) {
        byte[] ret = new byte[16];
        connector.updateInput(ret, cp);
        return ret;
    }

    private static void fillWithMax(byte[] inA, byte[] inB, byte[] out) {
        Preconditions.checkArgument((inA.length == 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((inB.length == 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((out.length == 16 ? 1 : 0) != 0);
        for (int i = 0; i < 16; ++i) {
            out[i] = (byte)Math.max(inA[i], inB[i]);
        }
    }
}

