/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.impl;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.api.wires.ConnectorTileHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;

public abstract class ImmersiveConnectableTileEntity
extends TileEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_226984_a_(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        super.func_226984_a_(worldIn, pos);
        this.globalNet = GlobalWireNetwork.getNetwork(worldIn);
    }

    @Nonnull
    public IModelData getModelData() {
        IEProperties.ConnectionModelData state = ConnectorTileHelper.genConnBlockState(this.field_145850_b, this);
        return CombinedModelData.combine(new SinglePropertyModelData<IEProperties.ConnectionModelData>(state, IEProperties.Model.CONNECTIONS), super.getModelData());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorTileHelper.onChunkUnload(this.globalNet, this);
    }

    public void onLoad() {
        super.onLoad();
        ConnectorTileHelper.onChunkLoad(this, this.field_145850_b);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ConnectorTileHelper.remove(this.field_145850_b, this);
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        return ConnectorTileHelper.getLocalNetWithCache(this.globalNet, this.func_174877_v(), cpIndex, this.cachedLocalNets);
    }
}

