/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;

public class ResettableLazy<T>
implements Supplier<T> {
    private final NonNullSupplier<T> getter;
    private final NonNullConsumer<T> destructor;
    @Nullable
    private T cached;

    public ResettableLazy(NonNullSupplier<T> getter) {
        this(getter, v -> {});
    }

    public ResettableLazy(NonNullSupplier<T> getter, NonNullConsumer<T> destructor) {
        this.getter = getter;
        this.destructor = destructor;
    }

    @Override
    @Nonnull
    public T get() {
        if (this.cached == null) {
            this.cached = this.getter.get();
        }
        return this.cached;
    }

    public void reset() {
        if (this.cached != null) {
            this.destructor.accept(this.cached);
            this.cached = null;
        }
    }
}

