/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.xp.IXpContainerItem;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;

public class XpHelper {
    private XpHelper() {
    }

    public static int getPlayerXP(PlayerEntity player) {
        return XpHelper.getTotalXpForLevel(player.field_71068_ca) + XpHelper.getExtraPlayerXp(player);
    }

    public static int getLevelPlayerXP(PlayerEntity player) {
        return XpHelper.getTotalXpForLevel(player.field_71068_ca);
    }

    public static int getExtraPlayerXp(PlayerEntity player) {
        return Math.round(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void setPlayerXP(PlayerEntity player, int exp) {
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        XpHelper.addXPToPlayer(player, exp);
    }

    public static void setPlayerLevel(PlayerEntity player, int level) {
        player.field_71068_ca = level;
        player.field_71106_cc = 0.0f;
    }

    public static void addXPToPlayer(PlayerEntity player, int exp) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (exp > i) {
            exp = i;
        }
        player.field_71106_cc += (float)exp / (float)player.func_71050_bK();
        player.field_71067_cb += exp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            XpHelper.addXPLevelToPlayer(player, 1);
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static void addXPLevelToPlayer(PlayerEntity player, int levels) {
        player.field_71068_ca += levels;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    public static void attemptStoreXP(PlayerEntity player, ExperienceOrbEntity orb) {
        if (player.field_70170_p.func_82737_E() - player.getPersistentData().func_74763_f("XpTimer") <= 40L) {
            ItemStack stack;
            PlayerInventory inventory = player.field_71071_by;
            for (int i = 0; !(i >= inventory.func_70302_i_() || (stack = inventory.func_70301_a(i)).func_77973_b() instanceof IXpContainerItem && IXpContainerItem.storeXpOrb(player, orb, stack)); ++i) {
            }
        }
    }

    public static int getTotalXpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }
}

