/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.crops;

import cofh.lib.block.impl.crops.CropsBlockCoFH;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class CropsBlockMushroom
extends CropsBlockCoFH {
    public CropsBlockMushroom(AbstractBlock.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder, type, growLight, growMod);
    }

    public CropsBlockMushroom(AbstractBlock.Properties builder, int growLight, float growMod) {
        this(builder, Constants.FUNGUS, growLight, growMod);
    }

    public CropsBlockMushroom(AbstractBlock.Properties properties) {
        this(properties, 0, 1.0f);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150391_bh) || state.func_203425_a(Blocks.field_196661_l);
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int age = this.func_185527_x(state);
        if (age < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(20 - age) == 0 ? 1 : 0) != 0)) {
            int newAge = age + 1 == this.getPostHarvestAge() ? this.func_185526_g() : age + 1;
            worldIn.func_180501_a(pos, this.func_185528_e(newAge), newAge == this.func_185526_g() ? 3 : 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Constants.MUSHROOMS_BY_AGE[MathHelper.clamp((Integer)state.func_177229_b((Property)this.func_185524_e()), 0, Constants.MUSHROOMS_BY_AGE.length - 1)];
    }

    @Override
    public IntegerProperty func_185524_e() {
        return Constants.AGE_0_4;
    }

    public int func_185526_g() {
        return 4;
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.nextInt(worldIn.field_73012_v, 0, 2);
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }
}

