/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.RedstoneControlPacket;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.IRedstoneControllable;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class RedstoneControlModule
implements IRedstoneControllable {
    protected IRedstoneControllableTile tile;
    protected BooleanSupplier enabled;
    protected int power;
    protected int threshold;
    protected IRedstoneControllable.ControlMode mode = IRedstoneControllable.ControlMode.DISABLED;

    public RedstoneControlModule(IRedstoneControllableTile tile) {
        this(tile, Constants.TRUE);
    }

    public RedstoneControlModule(IRedstoneControllableTile tile, BooleanSupplier enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public RedstoneControlModule setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.power = buffer.readByte();
        this.threshold = buffer.readByte();
        this.mode = IRedstoneControllable.ControlMode.VALUES[buffer.readByte()];
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.power);
        buffer.writeByte(this.threshold);
        buffer.writeByte(this.mode.ordinal());
    }

    public RedstoneControlModule read(CompoundNBT nbt) {
        CompoundNBT subTag = nbt.func_74775_l("RSControl");
        if (!subTag.isEmpty()) {
            this.power = subTag.func_74771_c("RSPower");
            this.threshold = subTag.func_74771_c("RSThreshold");
            this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[subTag.func_74771_c("RSMode")];
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.isControllable()) {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74774_a("RSPower", (byte)this.power);
            subTag.func_74774_a("RSThreshold", (byte)this.threshold);
            subTag.func_74774_a("RSMode", (byte)this.mode.ordinal());
            nbt.func_218657_a("RSControl", (INBT)subTag);
        }
        return nbt;
    }

    public RedstoneControlModule readSettings(CompoundNBT nbt) {
        CompoundNBT subTag = nbt.func_74775_l("RSControl");
        if (!subTag.isEmpty() && this.isControllable()) {
            this.threshold = subTag.func_74771_c("RSThreshold");
            this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[subTag.func_74771_c("RSMode")];
        }
        return this;
    }

    public CompoundNBT writeSettings(CompoundNBT nbt) {
        if (this.isControllable()) {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74774_a("RSThreshold", (byte)this.threshold);
            subTag.func_74774_a("RSMode", (byte)this.mode.ordinal());
            nbt.func_218657_a("RSControl", (INBT)subTag);
        }
        return nbt;
    }

    @Override
    public boolean isControllable() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IRedstoneControllable.ControlMode getMode() {
        return this.mode;
    }

    @Override
    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public void setControl(int threshold, IRedstoneControllable.ControlMode mode) {
        int curThreshold = this.threshold;
        IRedstoneControllable.ControlMode curMode = this.mode;
        this.threshold = threshold;
        this.mode = mode;
        if (Utils.isClientWorld(this.tile.world())) {
            RedstoneControlPacket.sendToServer(this.tile);
            this.threshold = curThreshold;
            this.mode = curMode;
        } else {
            this.tile.onControlUpdate();
        }
    }
}

