/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.ISecurableTile;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.control.ISecurable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SecurityControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected byte mode;

    public SecurityControlPacket() {
        super(33, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ISecurableTile) {
            ((ISecurableTile)tile).setAccess(ISecurable.AccessMode.VALUES[this.mode]);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.mode = buf.readByte();
    }

    public static void sendToServer(ISecurableTile tile) {
        SecurityControlPacket packet = new SecurityControlPacket();
        packet.pos = tile.pos();
        packet.mode = (byte)tile.securityControl().getAccess().ordinal();
        packet.sendToServer();
    }
}

