/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.util.references.CoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class EffectEvents {
    private static final int CLARITY_MOD = 20;

    private EffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderTeleportEvent(EnderTeleportEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a(CoreReferences.ENDERFERENCE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70644_a(CoreReferences.LIGHTNING_RESISTANCE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (source.func_151517_h()) {
            return;
        }
        if (source.func_94541_c() && entity.func_70644_a(CoreReferences.EXPLOSION_RESISTANCE)) {
            event.setCanceled(true);
        } else if (source.func_82725_o() && entity.func_70644_a(CoreReferences.MAGIC_RESISTANCE)) {
            event.setCanceled(true);
        } else if (source == DamageSource.field_180137_b && entity.func_70644_a(CoreReferences.LIGHTNING_RESISTANCE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleXpChangeEvent(PlayerXpEvent.XpChange event) {
        if (event.isCanceled() || event.getAmount() <= 0) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        EffectInstance clarityEffect = player.func_70660_b(CoreReferences.CLARITY);
        if (clarityEffect == null) {
            return;
        }
        event.setAmount(EffectEvents.getXPValue(event.getAmount(), clarityEffect.func_76458_c()));
    }

    private static int getXPValue(int baseExp, int amplifier) {
        return baseExp * (100 + 20 * (1 + amplifier)) / 100;
    }
}

