/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.client.CuriosClientConfig;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.client.gui.CuriosButton;
import top.theillusivec4.curios.client.gui.RenderButton;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketToggleRender;

public class CuriosScreen
extends ContainerScreen<CuriosContainer>
implements IRecipeShownListener {
    static final ResourceLocation CURIO_INVENTORY = new ResourceLocation("curios", "textures/gui/inventory.png");
    static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("minecraft:textures/gui/recipe_button.png");
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static float currentScroll;
    private final RecipeBookGui recipeBookGui = new RecipeBookGui();
    public boolean hasScrollBar;
    public boolean widthTooNarrow;
    private CuriosButton buttonCurios;
    private boolean isScrolling;
    private boolean buttonClicked;
    private boolean isRenderButtonHovered;

    public CuriosScreen(CuriosContainer curiosContainer, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)curiosContainer, playerInventory, title);
        this.field_230711_n_ = true;
    }

    public static Tuple<Integer, Integer> getButtonOffset(boolean isCreative) {
        CuriosClientConfig.Client client = CuriosClientConfig.CLIENT;
        CuriosClientConfig.Client.ButtonCorner corner = (CuriosClientConfig.Client.ButtonCorner)((Object)client.buttonCorner.get());
        int x = 0;
        int y = 0;
        if (isCreative) {
            x += corner.getCreativeXoffset() + (Integer)client.creativeButtonXOffset.get();
            y += corner.getCreativeYoffset() + (Integer)client.creativeButtonYOffset.get();
        } else {
            x += corner.getXoffset() + (Integer)client.buttonXOffset.get();
            y += corner.getYoffset() + (Integer)client.buttonYOffset.get();
        }
        return new Tuple((Object)x, (Object)y);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.field_230706_i_ != null) {
            if (this.field_230706_i_.field_71439_g != null) {
                this.hasScrollBar = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.field_230706_i_.field_71439_g).map(handler -> handler.getVisibleSlots() > 8).orElse(false);
                if (this.hasScrollBar) {
                    ((CuriosContainer)this.field_147002_h).scrollTo(currentScroll);
                }
            }
            int neededWidth = 431;
            if (this.hasScrollBar) {
                neededWidth += 30;
            }
            if (((CuriosContainer)this.field_147002_h).hasCosmeticColumn()) {
                neededWidth += 40;
            }
            this.widthTooNarrow = this.field_230708_k_ < neededWidth;
            this.recipeBookGui.func_201520_a(this.field_230708_k_, this.field_230709_l_, this.field_230706_i_, this.widthTooNarrow, (RecipeBookContainer)this.field_147002_h);
            this.updateScreenPosition();
            this.field_230705_e_.add(this.recipeBookGui);
            this.func_212928_a((IGuiEventListener)this.recipeBookGui);
            if (this.getMinecraft().field_71439_g != null && this.getMinecraft().field_71439_g.func_184812_l_() && this.recipeBookGui.func_191878_b()) {
                this.recipeBookGui.func_191866_a();
                this.updateScreenPosition();
            }
            Tuple<Integer, Integer> offsets = CuriosScreen.getButtonOffset(false);
            this.buttonCurios = new CuriosButton(this, this.getGuiLeft() + (Integer)offsets.func_76341_a(), this.field_230709_l_ / 2 + (Integer)offsets.func_76340_b(), 14, 14, 50, 0, 14, CURIO_INVENTORY);
            this.func_230480_a_((Widget)this.buttonCurios);
            if (!this.field_213127_e.field_70458_d.func_184812_l_()) {
                this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 104, this.field_230709_l_ / 2 - 22, 20, 18, 0, 0, 19, RECIPE_BUTTON_TEXTURE, button -> {
                    this.recipeBookGui.func_201518_a(this.widthTooNarrow);
                    this.recipeBookGui.func_191866_a();
                    this.updateScreenPosition();
                    ((ImageButton)button).func_191746_c(this.field_147003_i + 104, this.field_230709_l_ / 2 - 22);
                    this.buttonCurios.func_191746_c(this.field_147003_i + (Integer)offsets.func_76341_a(), this.field_230709_l_ / 2 + (Integer)offsets.func_76340_b());
                }));
            }
            this.updateRenderButtons();
        }
    }

    public void updateRenderButtons() {
        this.field_230710_m_.removeIf(widget -> widget instanceof RenderButton);
        this.field_230705_e_.removeIf(widget -> widget instanceof RenderButton);
        for (Slot inventorySlot : ((CuriosContainer)this.field_147002_h).field_75151_b) {
            if (!(inventorySlot instanceof CurioSlot) || inventorySlot instanceof CosmeticCurioSlot) continue;
            this.func_230480_a_((Widget)new RenderButton((CurioSlot)inventorySlot, this.field_147003_i + inventorySlot.field_75223_e + 11, this.field_147009_r + inventorySlot.field_75221_f - 3, 8, 8, 75, 0, 8, CURIO_INVENTORY, button -> NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketToggleRender(((CurioSlot)inventorySlot).getIdentifier(), inventorySlot.getSlotIndex()))));
        }
    }

    private void updateScreenPosition() {
        int i;
        if (this.recipeBookGui.func_191878_b() && !this.widthTooNarrow) {
            int offset = 148;
            if (this.hasScrollBar) {
                offset -= 30;
            }
            if (((CuriosContainer)this.field_147002_h).hasCosmeticColumn()) {
                offset -= 40;
            }
            i = 177 + (this.field_230708_k_ - this.field_146999_f - offset) / 2;
        } else {
            i = (this.field_230708_k_ - this.field_146999_f) / 2;
        }
        this.field_147003_i = i;
        this.updateRenderButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.recipeBookGui.func_193957_d();
    }

    private boolean inScrollBar(double mouseX, double mouseY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i - 34;
        int l = j + 12;
        int i1 = k + 14;
        int j1 = l + 139;
        if (((CuriosContainer)this.field_147002_h).hasCosmeticColumn()) {
            i1 -= 19;
            k -= 19;
        }
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (this.recipeBookGui.func_191878_b() && this.widthTooNarrow) {
            this.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
            this.recipeBookGui.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            Slot slot;
            this.recipeBookGui.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.recipeBookGui.func_230477_a_(matrixStack, this.field_147003_i, this.field_147009_r, true, partialTicks);
            boolean isButtonHovered = false;
            for (Widget button : this.field_230710_m_) {
                if (!(button instanceof RenderButton)) continue;
                ((RenderButton)button).renderButtonOverlay(matrixStack, mouseX, mouseY, partialTicks);
                if (!button.func_230449_g_()) continue;
                isButtonHovered = true;
            }
            this.isRenderButtonHovered = isButtonHovered;
            ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
            if (!this.isRenderButtonHovered && clientPlayer != null && clientPlayer.field_71071_by.func_70445_o().func_190926_b() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof CurioSlot && !slot.func_75216_d()) {
                CurioSlot slotCurio = (CurioSlot)slot;
                this.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(slotCurio.getSlotName()), mouseX, mouseY);
            }
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230459_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        ClientPlayerEntity clientPlayer;
        Minecraft mc = this.field_230706_i_;
        if (mc != null && (clientPlayer = mc.field_71439_g) != null && clientPlayer.field_71071_by.func_70445_o().func_190926_b()) {
            if (this.isRenderButtonHovered) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.curios.toggle"), mouseX, mouseY);
            } else if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
                this.func_230457_a_(matrixStack, this.field_147006_u.func_75211_c(), mouseX, mouseY);
            }
        }
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.recipeBookGui.func_191878_b() && this.widthTooNarrow) {
            this.recipeBookGui.func_191866_a();
            this.updateScreenPosition();
            return true;
        }
        if (KeyRegistry.openCurios.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            ClientPlayerEntity playerEntity = this.getMinecraft().field_71439_g;
            if (playerEntity != null) {
                playerEntity.func_71053_j();
            }
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null) {
            this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, 97.0f, 6.0f, 0x404040);
        }
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(field_147001_a);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
            InventoryScreen.func_228187_a_((int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.field_230706_i_.field_71439_g);
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.field_230706_i_.field_71439_g).ifPresent(handler -> {
                int slotCount = handler.getVisibleSlots();
                if (slotCount > 0) {
                    int upperHeight = 7 + Math.min(slotCount, 9) * 18;
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.getMinecraft().func_110434_K().func_110577_a(CURIO_INVENTORY);
                    int xTexOffset = 0;
                    int width = 27;
                    int xOffset = -26;
                    if (((CuriosContainer)this.field_147002_h).hasCosmeticColumn()) {
                        xTexOffset = 92;
                        width = 46;
                        xOffset -= 19;
                    }
                    this.func_238474_b_(matrixStack, i + xOffset, j + 4, xTexOffset, 0, width, upperHeight);
                    if (slotCount <= 8) {
                        this.func_238474_b_(matrixStack, i + xOffset, j + 4 + upperHeight, xTexOffset, 151, width, 7);
                    } else {
                        this.func_238474_b_(matrixStack, i + xOffset - 16, j + 4, 27, 0, 23, 158);
                        this.getMinecraft().func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
                        this.func_238474_b_(matrixStack, i + xOffset - 8, j + 12 + (int)(127.0f * currentScroll), 232, 0, 12, 15);
                    }
                    for (Slot slot : ((CuriosContainer)this.field_147002_h).field_75151_b) {
                        if (!(slot instanceof CosmeticCurioSlot)) continue;
                        int x = this.field_147003_i + slot.field_75223_e - 1;
                        int y = this.field_147009_r + slot.field_75221_f - 1;
                        this.getMinecraft().func_110434_K().func_110577_a(CURIO_INVENTORY);
                        this.func_238474_b_(matrixStack, x, y, 138, 0, 18, 18);
                    }
                }
            });
        }
    }

    protected boolean func_195359_a(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        if (this.isRenderButtonHovered) {
            return false;
        }
        return (!this.widthTooNarrow || !this.recipeBookGui.func_191878_b()) && super.func_195359_a(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.recipeBookGui.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.inScrollBar(mouseX, mouseY)) {
            this.isScrolling = this.needsScrollBars();
            return true;
        }
        return this.widthTooNarrow && this.recipeBookGui.func_191878_b() || super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseReleased1, double mouseReleased3, int mouseReleased5) {
        if (mouseReleased5 == 0) {
            this.isScrolling = false;
        }
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.func_231048_c_(mouseReleased1, mouseReleased3, mouseReleased5);
    }

    public boolean func_231045_a_(double pMouseDragged1, double pMouseDragged3, int pMouseDragged5, double pMouseDragged6, double pMouseDragged8) {
        if (this.isScrolling) {
            int i = this.field_147009_r + 8;
            int j = i + 148;
            currentScroll = ((float)pMouseDragged3 - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            currentScroll = MathHelper.func_76131_a((float)currentScroll, (float)0.0f, (float)1.0f);
            ((CuriosContainer)this.field_147002_h).scrollTo(currentScroll);
            return true;
        }
        return super.func_231045_a_(pMouseDragged1, pMouseDragged3, pMouseDragged5, pMouseDragged6, pMouseDragged8);
    }

    public boolean func_231043_a_(double pMouseScrolled1, double pMouseScrolled3, double pMouseScrolled5) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = ((CuriosContainer)this.field_147002_h).curiosHandler.map(ICuriosItemHandler::getVisibleSlots).orElse(1);
        currentScroll = (float)((double)currentScroll - pMouseScrolled5 / (double)i);
        currentScroll = MathHelper.func_76131_a((float)currentScroll, (float)0.0f, (float)1.0f);
        ((CuriosContainer)this.field_147002_h).scrollTo(currentScroll);
        return true;
    }

    private boolean needsScrollBars() {
        return ((CuriosContainer)this.field_147002_h).canScroll();
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.field_146999_f) || mouseY >= (double)(guiTopIn + this.field_147000_g);
        return this.recipeBookGui.func_195604_a(mouseX, mouseY, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g, mouseButton) && flag;
    }

    protected void func_184098_a(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        this.recipeBookGui.func_191874_a(slotIn);
    }

    public void func_192043_J_() {
        this.recipeBookGui.func_193948_e();
    }

    public void func_231164_f_() {
        this.recipeBookGui.func_191871_c();
        super.func_231164_f_();
    }

    @Nonnull
    public RecipeBookGui func_194310_f() {
        return this.recipeBookGui;
    }
}

