/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.patchouli;

import cofh.thermal.core.util.recipes.machine.SmelterRecipe;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class SmelterProcessor
implements IComponentProcessor {
    private SmelterRecipe recipe;

    public void setup(IVariableProvider variables) {
        if (!variables.has("recipe")) {
            return;
        }
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        IRecipe recipe = (IRecipe)Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(recipeId).get();
        if (recipe == null) {
            LogManager.getLogger().warn("Thermalpedia missing the smelter recipe: " + recipeId);
        } else {
            this.recipe = (SmelterRecipe)recipe;
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("out")) {
            return IVariable.from(this.recipe.getOutputItems().get(0));
        }
        if (key.startsWith("in")) {
            int index = Integer.parseInt(key.substring(key.length() - 1)) - 1;
            if (this.recipe.getInputItems().size() <= index) {
                return null;
            }
            return IVariable.wrapList((Iterable)Arrays.stream(((Ingredient)this.recipe.getInputItems().get(index)).func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
        }
        return null;
    }
}

