/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.network;

import com.progwml6.ironchest.common.network.InventoryTopStacksSyncPacket;
import com.progwml6.ironchest.common.network.helper.ISimplePacket;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class IronChestNetwork {
    private static IronChestNetwork instance = null;
    public final SimpleChannel network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("ironchest", "network")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private int id = 0;
    private static final String PROTOCOL_VERSION = Integer.toString(1);

    public static IronChestNetwork getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Attempt to call network getInstance before network is setup");
        }
        return instance;
    }

    public static void setup() {
        if (instance != null) {
            return;
        }
        instance = new IronChestNetwork();
        instance.registerPacket(InventoryTopStacksSyncPacket.class, InventoryTopStacksSyncPacket::new, NetworkDirection.PLAY_TO_CLIENT);
    }

    public <MSG extends ISimplePacket> void registerPacket(Class<MSG> clazz, Function<PacketBuffer, MSG> decoder, @Nullable NetworkDirection direction) {
        this.registerPacket(clazz, ISimplePacket::encode, decoder, ISimplePacket::handle, direction);
    }

    public <MSG> void registerPacket(Class<MSG> clazz, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer, @Nullable NetworkDirection direction) {
        this.network.registerMessage(this.id++, clazz, encoder, decoder, consumer, Optional.ofNullable(direction));
    }

    public void sendToServer(Object msg) {
        this.network.sendToServer(msg);
    }

    public void send(PacketDistributor.PacketTarget target, Object message) {
        this.network.send(target, message);
    }

    public void sendVanillaPacket(IPacket<?> packet, Entity player) {
        if (player instanceof ServerPlayerEntity && ((ServerPlayerEntity)player).field_71135_a != null) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a(packet);
        }
    }

    public void sendTo(Object msg, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            this.sendTo(msg, (ServerPlayerEntity)player);
        }
    }

    public void sendTo(Object msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            this.network.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void sendToClientsAround(Object msg, ServerWorld serverWorld, BlockPos position) {
        Chunk chunk = serverWorld.func_175726_f(position);
        this.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public void sendToTrackingAndSelf(Object msg, Entity entity) {
        this.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public void sendToTracking(Object msg, Entity entity) {
        this.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
    }

    public void sendToClientsAround(Object msg, @Nullable IWorld world, BlockPos position) {
        if (world instanceof ServerWorld) {
            this.sendToClientsAround(msg, (ServerWorld)world, position);
        }
    }
}

