/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.block.tileentity;

import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.tileentity.GenericIronChestTileEntity;
import com.progwml6.ironchest.common.block.tileentity.IronChestsTileEntityTypes;
import com.progwml6.ironchest.common.inventory.IronChestContainer;
import com.progwml6.ironchest.common.network.InventoryTopStacksSyncPacket;
import com.progwml6.ironchest.common.network.IronChestNetwork;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.world.server.ServerWorld;

public class CrystalChestTileEntity
extends GenericIronChestTileEntity {
    private NonNullList<ItemStack> topStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private boolean inventoryTouched;
    private boolean hadStuff;

    public CrystalChestTileEntity() {
        super((TileEntityType)IronChestsTileEntityTypes.CRYSTAL_CHEST.get(), IronChestsTypes.CRYSTAL, () -> IronChestsBlocks.CRYSTAL_CHEST.get());
    }

    @Override
    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return IronChestContainer.createCrystalContainer(id, playerInventory, (IInventory)this);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
    }

    @Override
    public void func_199721_a(NonNullList<ItemStack> contents) {
        super.func_199721_a(contents);
        this.inventoryTouched = true;
    }

    public ItemStack func_70301_a(int index) {
        this.inventoryTouched = true;
        return super.func_70301_a(index);
    }

    public NonNullList<ItemStack> getTopItems() {
        return this.topStacks;
    }

    private void sortTopStacks() {
        int i;
        if (!this.getChestType().isTransparent() || this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        NonNullList tempCopy = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = (ItemStack)this.func_190576_q().get(i);
            if (itemStack.func_190926_b()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.func_185132_d((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.func_190916_E() == tempCopyStack.func_190916_E()) continue block0;
                tempCopyStack.func_190917_f(itemStack.func_190916_E());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.func_77946_l());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.getTopItems().size(); ++i) {
                this.getTopItems().set(i, (Object)ItemStack.field_190927_a);
            }
            if (this.field_145850_b != null) {
                BlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            }
            return;
        }
        this.hadStuff = true;
        Collections.sort(tempCopy, (stack1, stack2) -> {
            if (stack1.func_190926_b()) {
                return 1;
            }
            if (stack2.func_190926_b()) {
                return -1;
            }
            return stack2.func_190916_E() - stack1.func_190916_E();
        });
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element.func_190926_b() || element.func_190916_E() <= 0) continue;
            if (p == this.getTopItems().size()) break;
            this.getTopItems().set(p, (Object)element);
            ++p;
        }
        for (int i2 = p; i2 < this.getTopItems().size(); ++i2) {
            this.getTopItems().set(i2, (Object)ItemStack.field_190927_a);
        }
        if (this.field_145850_b != null) {
            BlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
        }
        this.sendTopStacksPacket();
    }

    public NonNullList<ItemStack> buildItemStackDataList() {
        if (this.getChestType().isTransparent()) {
            NonNullList sortList = NonNullList.func_191197_a((int)this.getTopItems().size(), (Object)ItemStack.field_190927_a);
            int pos = 0;
            for (ItemStack is : this.topStacks) {
                if (!is.func_190926_b()) {
                    sortList.set(pos, (Object)is);
                } else {
                    sortList.set(pos, (Object)ItemStack.field_190927_a);
                }
                ++pos;
            }
            return sortList;
        }
        return NonNullList.func_191197_a((int)this.getTopItems().size(), (Object)ItemStack.field_190927_a);
    }

    protected void sendTopStacksPacket() {
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        if (this.field_145850_b != null && this.field_145850_b instanceof ServerWorld && !this.field_145850_b.field_72995_K) {
            IronChestNetwork.getInstance().sendToClientsAround((Object)new InventoryTopStacksSyncPacket(stacks, this.field_174879_c), (ServerWorld)this.field_145850_b, this.field_174879_c);
        }
    }

    public void receiveMessageFromServer(NonNullList<ItemStack> topStacks) {
        this.topStacks = topStacks;
    }
}

