/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.progwml6.ironchest.client.model.IronChestsModels;
import com.progwml6.ironchest.client.model.inventory.ModelItem;
import com.progwml6.ironchest.common.block.GenericIronChestBlock;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.tileentity.CrystalChestTileEntity;
import com.progwml6.ironchest.common.block.tileentity.GenericIronChestTileEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class IronChestTileEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final ModelRenderer chestLid;
    private final ModelRenderer chestBottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer chestLock;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronChestTileEntityRenderer(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
        this.chestBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.chestLid = new ModelRenderer(64, 64, 0, 0);
        this.chestLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.chestLid.field_78797_d = 9.0f;
        this.chestLid.field_78798_e = 1.0f;
        this.chestLock = new ModelRenderer(64, 64, 0, 0);
        this.chestLock.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.chestLock.field_78797_d = 8.0f;
    }

    public void func_225616_a_(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        GenericIronChestTileEntity tileEntity = (GenericIronChestTileEntity)((Object)tileEntityIn);
        World world = tileEntity.func_145831_w();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntity.func_195044_w() : (BlockState)tileEntity.getBlockToUse().func_176223_P().func_206870_a((Property)GenericIronChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockstate.func_177230_c();
        IronChestsTypes chestType = IronChestsTypes.IRON;
        IronChestsTypes actualType = GenericIronChestBlock.getTypeFromBlock(block);
        if (actualType != null) {
            chestType = actualType;
        }
        if (block instanceof GenericIronChestBlock) {
            GenericIronChestBlock ironChestBlock = (GenericIronChestBlock)block;
            matrixStackIn.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((Property)GenericIronChestBlock.FACING)).func_185119_l();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper<? extends GenericIronChestTileEntity> iCallbackWrapper = flag ? ironChestBlock.getWrapper(blockstate, world, tileEntity.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)iCallbackWrapper.apply(GenericIronChestBlock.getLid(tileEntity))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)iCallbackWrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLightIn);
            RenderMaterial material = new RenderMaterial(Atlases.field_228747_f_, IronChestsModels.chooseChestTexture(chestType));
            IVertexBuilder ivertexbuilder = material.func_229311_a_(bufferIn, RenderType::func_228638_b_);
            this.handleModelRender(matrixStackIn, ivertexbuilder, this.chestLid, this.chestLock, this.chestBottom, f1, i, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
            if (chestType.isTransparent() && tileEntity instanceof CrystalChestTileEntity && Vector3d.func_237489_a_((Vector3i)tileEntityIn.func_174877_v()).func_237488_a_((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), 128.0)) {
                float rotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
                CrystalChestTileEntity crystalChestTileEntity = (CrystalChestTileEntity)tileEntity;
                for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                    IronChestTileEntityRenderer.renderItem(matrixStackIn, bufferIn, (ItemStack)crystalChestTileEntity.getTopItems().get(j), MODEL_ITEMS.get(j), rotation, combinedLightIn);
                }
            }
        }
    }

    private void handleModelRender(MatrixStack matrixStackIn, IVertexBuilder iVertexBuilder, ModelRenderer firstModel, ModelRenderer secondModel, ModelRenderer thirdModel, float f1, int p_228871_7_, int p_228871_8_) {
        secondModel.field_78795_f = firstModel.field_78795_f = -(f1 * 1.5707964f);
        firstModel.func_228308_a_(matrixStackIn, iVertexBuilder, p_228871_7_, p_228871_8_);
        secondModel.func_228308_a_(matrixStackIn, iVertexBuilder, p_228871_7_, p_228871_8_);
        thirdModel.func_228308_a_(matrixStackIn, iVertexBuilder, p_228871_7_, p_228871_8_);
    }

    public static void renderItem(MatrixStack matrices, IRenderTypeBuffer buffer, ItemStack item, ModelItem modelItem, float rotation, int light) {
        if (item.func_190926_b()) {
            return;
        }
        matrices.func_227860_a_();
        Vector3f center = modelItem.getCenter();
        matrices.func_227861_a_((double)center.func_195899_a(), (double)center.func_195900_b(), (double)center.func_195902_c());
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.func_227862_a_(scale, scale, scale);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, matrices, buffer);
        matrices.func_227865_b_();
    }
}

