/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.handler.event;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillWeapon;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.demonaura.PosXY;
import wayoftime.bloodmagic.demonaura.WillChunk;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.will.DemonWillHolder;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WillHandler {
    private static final HashMap<ResourceLocation, Integer> SERVER_TICKS = new HashMap();

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (stack.func_77973_b() instanceof IDemonWill) {
            PlayerEntity player = event.getPlayer();
            EnumDemonWillType pickupType = ((IDemonWill)stack.func_77973_b()).getType(stack);
            ItemStack remainder = PlayerDemonWillHandler.addDemonWill(player, stack);
            if (remainder == null || ((IDemonWill)stack.func_77973_b()).getWill(pickupType, stack) < 1.0E-4 || PlayerDemonWillHandler.isDemonWillFull(pickupType, player)) {
                stack.func_190920_e(0);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        IDemonWillWeapon demonWillWeapon;
        List<ItemStack> droppedSouls;
        PlayerEntity player;
        ItemStack heldStack;
        LivingEntity attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity entity = source.func_76346_g();
        if (attackedEntity.func_70644_a(BloodMagicPotions.SOUL_SNARE) && (attackedEntity instanceof MobEntity || attackedEntity.func_130014_f_().func_175659_aa() == Difficulty.PEACEFUL)) {
            EffectInstance eff = attackedEntity.func_70660_b(BloodMagicPotions.SOUL_SNARE);
            int lvl = eff.func_76458_c();
            double amountOfSouls = attackedEntity.func_130014_f_().field_73012_v.nextDouble() * (double)(lvl + 1) * (double)(lvl + 1) * 4.0 + 1.0;
            ItemStack soulStack = ((IDemonWill)BloodMagicItems.MONSTER_SOUL_RAW.get()).createWill(amountOfSouls);
            event.getDrops().add(new ItemEntity(attackedEntity.func_130014_f_(), attackedEntity.func_226277_ct_(), attackedEntity.func_226278_cu_(), attackedEntity.func_226281_cx_(), soulStack));
        }
        if (entity != null && entity instanceof PlayerEntity && (heldStack = (player = (PlayerEntity)entity).func_184614_ca()).func_77973_b() instanceof IDemonWillWeapon && !player.func_130014_f_().field_72995_K && !(droppedSouls = (demonWillWeapon = (IDemonWillWeapon)heldStack.func_77973_b()).getRandomDemonWillDrop(attackedEntity, (LivingEntity)player, heldStack, event.getLootingLevel())).isEmpty()) {
            for (ItemStack willStack : droppedSouls) {
                ItemStack remainder = PlayerDemonWillHandler.addDemonWill(player, willStack);
                if (remainder.func_190926_b()) continue;
                EnumDemonWillType pickupType = ((IDemonWill)remainder.func_77973_b()).getType(remainder);
                if (!(((IDemonWill)remainder.func_77973_b()).getWill(pickupType, remainder) >= 1.0E-4)) continue;
                event.getDrops().add(new ItemEntity(attackedEntity.func_130014_f_(), attackedEntity.func_226277_ct_(), attackedEntity.func_226278_cu_(), attackedEntity.func_226281_cx_(), remainder));
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent
    public void onServerWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation(event.world);
        if (event.phase == TickEvent.Phase.END) {
            ConcurrentLinkedQueue<PosXY> dirtyChunks;
            int ticks;
            if (!SERVER_TICKS.containsKey(rl)) {
                SERVER_TICKS.put(rl, 0);
            }
            if ((ticks = SERVER_TICKS.get(rl).intValue()) % 20 == 0 && (dirtyChunks = WorldDemonWillHandler.dirtyChunks.get(rl)) != null && dirtyChunks.size() > 0) {
                for (PosXY pos : dirtyChunks) {
                    IChunk chunk = event.world.func_217353_a(pos.x, pos.y, ChunkStatus.field_222617_m, false);
                    if (chunk == null) continue;
                    chunk.func_177427_f(true);
                }
                dirtyChunks.clear();
            }
            SERVER_TICKS.put(rl, ticks + 1);
        }
    }

    public static boolean isBlockLoaded(IBlockReader world, BlockPos pos) {
        if (world == null || !World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        if (world instanceof IWorldReader) {
            return ((IWorldReader)world).func_175667_e(pos);
        }
        return true;
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation((World)event.getWorld());
        ChunkPos loc = event.getChunk().func_76632_l();
        CompoundNBT nbt = new CompoundNBT();
        event.getData().func_218657_a("BloodMagic", (INBT)nbt);
        WillChunk ac = WorldDemonWillHandler.getWillChunk(rl, loc.field_77276_a, loc.field_77275_b);
        if (ac != null) {
            nbt.func_74777_a("base", ac.getBase());
            ac.getCurrentWill().writeToNBT(nbt, "current");
            if (!event.getWorld().func_72863_F().func_222865_a(event.getChunk().func_76632_l())) {
                WorldDemonWillHandler.removeWillChunk(rl, loc.field_77276_a, loc.field_77275_b);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation((World)event.getWorld());
        if (event.getData().func_74775_l("BloodMagic").func_74764_b("base")) {
            CompoundNBT nbt = event.getData().func_74775_l("BloodMagic");
            short base = nbt.func_74765_d("base");
            DemonWillHolder current = new DemonWillHolder();
            current.readFromNBT(nbt, "current");
            WorldDemonWillHandler.addWillChunk(rl, event.getChunk(), base, current);
        } else {
            WorldDemonWillHandler.generateWill(event.getChunk(), (World)event.getWorld());
        }
    }
}

