/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class GhostItemHelper {
    public static void setItemGhostAmount(ItemStack stack, int amount) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74768_a("stackSize", amount);
    }

    public static int getItemGhostAmount(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74762_e("stackSize");
    }

    public static boolean hasGhostAmount(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74764_b("stackSize");
    }

    public static void incrementGhostAmout(ItemStack stack, int value) {
        int amount = GhostItemHelper.getItemGhostAmount(stack);
        GhostItemHelper.setItemGhostAmount(stack, amount += value);
    }

    public static void decrementGhostAmount(ItemStack stack, int value) {
        int amount = GhostItemHelper.getItemGhostAmount(stack);
        GhostItemHelper.setItemGhostAmount(stack, amount -= value);
    }

    public static ItemStack getStackFromGhost(ItemStack ghostStack) {
        ItemStack newStack = ghostStack.func_77946_l();
        NBTHelper.checkNBT(newStack);
        CompoundNBT tag = newStack.func_77978_p();
        int amount = GhostItemHelper.getItemGhostAmount(ghostStack);
        tag.func_82580_o("stackSize");
        if (tag.isEmpty()) {
            newStack.func_77982_d(null);
        }
        newStack.func_190920_e(amount);
        return newStack;
    }

    public static ItemStack getSingleStackFromGhost(ItemStack ghostStack) {
        ItemStack newStack = ghostStack.func_77946_l();
        NBTHelper.checkNBT(newStack);
        CompoundNBT tag = newStack.func_77978_p();
        tag.func_82580_o("stackSize");
        if (tag.isEmpty()) {
            newStack.func_77982_d(null);
        }
        newStack.func_190920_e(1);
        return newStack;
    }
}

