/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.harvest;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;

public class HarvestRegistry {
    private static final List<IHarvestHandler> HARVEST_HANDLERS = Lists.newArrayList();
    private static final Map<Block, Integer> STANDARD_CROPS = Maps.newHashMap();
    private static final Set<BlockState> TALL_CROPS = Sets.newHashSet();
    private static final Multimap<BlockState, BlockState> STEM_CROPS = ArrayListMultimap.create();
    private static final Map<BlockState, Integer> AMPLIFIERS = Maps.newHashMap();

    public static void registerHandler(IHarvestHandler handler) {
        if (!HARVEST_HANDLERS.contains(handler)) {
            HARVEST_HANDLERS.add(handler);
        }
    }

    public static void registerStandardCrop(Block crop, int matureMeta) {
        if (!STANDARD_CROPS.containsKey(crop)) {
            STANDARD_CROPS.put(crop, matureMeta);
        }
    }

    public static void registerTallCrop(BlockState crop) {
        if (!TALL_CROPS.contains(crop)) {
            TALL_CROPS.add(crop);
        }
    }

    public static void registerStemCrop(BlockState crop, BlockState stem) {
        if (!STEM_CROPS.containsKey((Object)crop) && stem.func_177230_c() instanceof AttachedStemBlock) {
            STEM_CROPS.put((Object)stem, (Object)crop);
        }
    }

    public static void registerRangeAmplifier(BlockState block, int range) {
        if (!AMPLIFIERS.containsKey(block)) {
            AMPLIFIERS.put(block, range);
        }
    }

    public static List<IHarvestHandler> getHarvestHandlers() {
        return ImmutableList.copyOf(HARVEST_HANDLERS);
    }

    public static Map<Block, Integer> getStandardCrops() {
        return ImmutableMap.copyOf(STANDARD_CROPS);
    }

    public static Set<BlockState> getTallCrops() {
        return ImmutableSet.copyOf(TALL_CROPS);
    }

    public static Multimap<BlockState, BlockState> getStemCrops() {
        return ImmutableMultimap.copyOf(STEM_CROPS);
    }

    public static Map<BlockState, Integer> getAmplifiers() {
        return ImmutableMap.copyOf(AMPLIFIERS);
    }
}

