/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;

public class RecipeTartaricForge
extends BloodMagicRecipe {
    @Nonnull
    private final List<Ingredient> input;
    @Nonnull
    private final ItemStack output;
    @Nonnegative
    private final double minimumSouls;
    @Nonnegative
    private final double soulDrain;

    public RecipeTartaricForge(ResourceLocation id, @Nonnull List<Ingredient> input, @Nonnull ItemStack output, @Nonnegative double minimumSouls, @Nonnegative double soulDrain) {
        super(id);
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumSouls >= 0.0 ? 1 : 0) != 0, (Object)"minimumSouls cannot be negative.");
        Preconditions.checkArgument((soulDrain >= 0.0 ? 1 : 0) != 0, (Object)"soulDrain cannot be negative.");
        this.input = input;
        this.output = output;
        this.minimumSouls = minimumSouls;
        this.soulDrain = soulDrain;
    }

    @Nonnull
    public final List<Ingredient> getInput() {
        return this.input;
    }

    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    @Nonnegative
    public final double getMinimumSouls() {
        return this.minimumSouls;
    }

    @Nonnegative
    public final double getSoulDrain() {
        return this.soulDrain;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.input.size());
        for (int i = 0; i < this.input.size(); ++i) {
            this.input.get(i).func_199564_a(buffer);
        }
        buffer.func_150788_a(this.output);
        buffer.writeDouble(this.minimumSouls);
        buffer.writeDouble(this.soulDrain);
    }

    public IRecipeSerializer<RecipeTartaricForge> func_199559_b() {
        return BloodMagicRecipeSerializers.TARTARIC.getRecipeSerializer();
    }

    public IRecipeType<RecipeTartaricForge> func_222127_g() {
        return BloodMagicRecipeType.TARTARICFORGE;
    }
}

