/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.data;

import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SoulTicket {
    private static final ITextComponent EMPTY = new StringTextComponent("");
    private final ITextComponent description;
    private final int amount;

    public SoulTicket(ITextComponent description, int amount) {
        this.description = description;
        this.amount = amount;
    }

    public SoulTicket(int amount) {
        this(EMPTY, amount);
    }

    public boolean isSyphon() {
        return this.amount < 0;
    }

    public ITextComponent getDescription() {
        return this.description;
    }

    public int getAmount() {
        return this.amount;
    }

    public static SoulTicket block(World world, BlockPos pos, int amount) {
        return new SoulTicket((ITextComponent)new StringTextComponent("block|" + world.func_234923_W_().getRegistryName() + "|" + pos.func_218275_a()), amount);
    }

    public static SoulTicket item(ItemStack itemStack, World world, Entity entity, int amount) {
        return new SoulTicket((ITextComponent)new StringTextComponent("item|" + itemStack.func_77973_b().getRegistryName() + "|" + world.func_234923_W_().getRegistryName() + "|" + entity.func_189512_bd()), amount);
    }

    public static SoulTicket item(ItemStack itemStack, World world, BlockPos pos, int amount) {
        return new SoulTicket((ITextComponent)new StringTextComponent("item|" + itemStack.func_77973_b().getRegistryName() + "|" + world.func_234923_W_().getRegistryName() + "|" + pos.func_218275_a()), amount);
    }

    public static SoulTicket item(ItemStack itemStack, int amount) {
        return new SoulTicket((ITextComponent)new StringTextComponent("item|" + itemStack.func_77973_b().getRegistryName()), amount);
    }

    public static SoulTicket command(ICommandSource sender, String command, int amount) {
        return new SoulTicket((ITextComponent)new StringTextComponent("command|" + command + "|" + sender.toString()), amount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SoulTicket) {
            return ((SoulTicket)o).getDescription().equals(this.description);
        }
        return false;
    }

    public int hashCode() {
        return this.description.hashCode();
    }
}

