/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.crt;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByOutput;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.openzen.zencode.java.ZenCodeType;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

@ZenRegister
@ZenCodeType.Name(value="mods.bloodmagic.ARC")
public class ARCManager
implements IRecipeManager {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IFluidStack outputFluid, IIngredient input, IFluidStack inputFluid, IIngredient arcTool, boolean consumeIngredient, @ZenCodeType.Optional MCWeightedItemStack[] addedItems) {
        name = this.fixRecipeName(name);
        ResourceLocation location = new ResourceLocation("crafttweaker", name);
        ArrayList<Pair<ItemStack, Double>> addedItemsList = new ArrayList();
        if (addedItems != null) {
            addedItemsList = Arrays.stream(addedItems).map(mcWeightedItemStack -> Pair.of((Object)mcWeightedItemStack.getItemStack().getInternal(), (Object)mcWeightedItemStack.getWeight())).collect(Collectors.toList());
        }
        RecipeARC recipeARC = new RecipeARC(location, input.asVanillaIngredient(), arcTool.asVanillaIngredient(), inputFluid.getInternal().isEmpty() ? null : FluidStackIngredient.from(inputFluid.getInternal()), output.getInternal(), addedItemsList, outputFluid.getInternal(), consumeIngredient);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipeARC, ""));
    }

    public void removeRecipe(final IItemStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipeByOutput(this, output){

            public void apply() {
                ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
                for (ResourceLocation location : this.getManager().getRecipes().keySet()) {
                    RecipeARC recipeARC;
                    List<ItemStack> allListedOutputs;
                    IRecipe recipe = (IRecipe)this.getManager().getRecipes().get(location);
                    if (!(recipe instanceof RecipeARC) || (allListedOutputs = (recipeARC = (RecipeARC)recipe).getAllListedOutputs()).size() <= 0 || !output.matches((IItemStack)new MCItemStackMutable(allListedOutputs.get(0)))) continue;
                    toRemove.add(location);
                }
                toRemove.forEach(this.getManager().getRecipes()::remove);
            }
        });
    }

    public IRecipeType<RecipeARC> getRecipeType() {
        return BloodMagicRecipeType.ARC;
    }
}

