/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class AlchemyArrayRecipeSerializer<RECIPE extends RecipeAlchemyArray>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public AlchemyArrayRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input1 = JSONUtils.func_151202_d((JsonObject)json, (String)"baseinput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"baseinput") : JSONUtils.func_152754_s((JsonObject)json, (String)"baseinput");
        JsonArray input2 = JSONUtils.func_151202_d((JsonObject)json, (String)"addedinput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"addedinput") : JSONUtils.func_152754_s((JsonObject)json, (String)"addedinput");
        Ingredient baseInput = Ingredient.func_199802_a((JsonElement)input1);
        Ingredient addedInput = Ingredient.func_199802_a((JsonElement)input2);
        ResourceLocation texture = null;
        if (json.has("texture")) {
            texture = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"texture"));
        }
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        return this.factory.create(recipeId, texture, baseInput, addedInput, output);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        ResourceLocation texture = null;
        if (buffer.readBoolean()) {
            texture = buffer.func_192575_l();
        }
        Ingredient baseInput = Ingredient.func_199566_b((PacketBuffer)buffer);
        Ingredient addedInput = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack output = buffer.func_150791_c();
        return this.factory.create(recipeId, texture, baseInput, addedInput, output);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipeAlchemyArray)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeAlchemyArray> {
        public RECIPE create(ResourceLocation var1, ResourceLocation var2, Ingredient var3, Ingredient var4, ItemStack var5);
    }
}

