/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import wayoftime.bloodmagic.common.item.IActivatable;
import wayoftime.bloodmagic.common.item.ItemSigil;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilToggleable
extends ItemSigil
implements IActivatable {
    public ItemSigilToggleable(Item.Properties property, int lpUsed) {
        super(property, lpUsed);
    }

    @Override
    public boolean getActivated(ItemStack stack) {
        return !stack.func_190926_b() && NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
    }

    @Override
    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (!stack.func_190926_b()) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!world.field_72995_K && !this.isUnusable(stack)) {
            if (player.func_225608_bj_()) {
                this.setActivatedState(stack, !this.getActivated(stack));
            }
            if (this.getActivated(stack)) {
                return super.func_77659_a(world, player, hand);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Binding binding;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if ((binding = this.getBinding(stack)) == null || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        return this.onSigilUse(stack, player, world, blockpos, context.func_196000_l(), context.func_221532_j()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public boolean onSigilUse(ItemStack itemStack, PlayerEntity player, World world, BlockPos blockPos, Direction side, Vector3d hitVec) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && entityIn instanceof PlayerEntity && this.getActivated(stack)) {
            if (entityIn.field_70173_aa % 100 == 0 && !NetworkHelper.getSoulNetwork(this.getBinding(stack)).syphonAndDamage((PlayerEntity)entityIn, SoulTicket.item(stack, worldIn, entityIn, this.getLpUsed())).isSuccess()) {
                this.setActivatedState(stack, false);
            }
            this.onSigilUpdate(stack, worldIn, (PlayerEntity)entityIn, itemSlot, isSelected);
        }
    }

    public void onSigilUpdate(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected) {
    }
}

