/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDiscreteDemonWill;
import wayoftime.bloodmagic.common.item.ItemBloodOrb;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRitualReaderState;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class ItemRitualReader
extends Item {
    public static final String tooltipBase = "tooltip.bloodmagic.ritualReader.";

    public ItemRitualReader() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        EnumRitualReaderState state = this.getState(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.ritualReader.currentState", new Object[]{TextHelper.localizeEffect(tooltipBase + state.toString().toLowerCase(), new Object[0])}).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        boolean sneaking = Screen.func_231173_s_();
        if (sneaking) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.ritualReader.desc." + state.toString().toLowerCase()).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.extraInfo").func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockRayTraceResult ray = Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (ray != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                this.cycleReader(stack, player);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        Hand hand = context.func_221531_n();
        Direction direction = context.func_196000_l();
        if (!world.field_72995_K) {
            BlockPos masterPos;
            EnumRitualReaderState state = this.getState(stack);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IMasterRitualStone) {
                IMasterRitualStone master = (IMasterRitualStone)tile;
                if (master.getCurrentRitual() == null) {
                    super.func_195939_a(context);
                }
                this.setMasterBlockPos(stack, pos);
                this.setBlockPos(stack, BlockPos.field_177992_a);
                switch (state) {
                    case INFORMATION: {
                        master.provideInformationOfRitualToPlayer(player);
                        break;
                    }
                    case SET_AREA: {
                        if (player.func_225608_bj_() && player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof ItemBloodOrb) {
                            Ritual ritual = master.getCurrentRitual();
                            for (String range : ritual.getListOfRanges()) {
                                AreaDescriptor aabb = ritual.getBlockRange(range);
                                master.setBlockRange(range, aabb);
                            }
                            break;
                        }
                        String range = this.getCurrentBlockRange(stack);
                        if (range == null || range.isEmpty() || player.func_225608_bj_()) {
                            String newRange;
                            range = newRange = master.getNextBlockRange(range);
                            this.setCurrentBlockRange(stack, newRange);
                        }
                        master.provideInformationOfRangeToPlayer(player, range);
                        break;
                    }
                    case SET_WILL_TYPES: {
                        ArrayList<EnumDemonWillType> typeList = new ArrayList<EnumDemonWillType>();
                        NonNullList inv = player.field_71071_by.field_70462_a;
                        for (int i = 0; i < 9; ++i) {
                            EnumDemonWillType type;
                            ItemStack testStack = (ItemStack)inv.get(i);
                            if (testStack.func_190926_b() || !(testStack.func_77973_b() instanceof IDiscreteDemonWill) || typeList.contains((Object)(type = ((IDiscreteDemonWill)testStack.func_77973_b()).getType(testStack)))) continue;
                            typeList.add(type);
                        }
                        master.setActiveWillConfig(player, typeList);
                        master.provideInformationOfWillConfigToPlayer(player, typeList);
                    }
                }
                return ActionResultType.FAIL;
            }
            if (state == EnumRitualReaderState.SET_AREA && !(masterPos = this.getMasterBlockPos(stack)).equals((Object)BlockPos.field_177992_a)) {
                BlockPos containedPos = this.getBlockPos(stack);
                if (containedPos.equals((Object)BlockPos.field_177992_a)) {
                    BlockPos pos1 = pos.func_177973_b((Vector3i)masterPos);
                    this.setBlockPos(stack, pos1);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.bloodmagic.blockRange.firstBlock"), true);
                } else {
                    tile = world.func_175625_s(masterPos);
                    if (tile instanceof IMasterRitualStone) {
                        IMasterRitualStone master = (IMasterRitualStone)tile;
                        BlockPos pos2 = pos.func_177973_b((Vector3i)masterPos);
                        String range = this.getCurrentBlockRange(stack);
                        if (range == null || range.isEmpty()) {
                            String newRange;
                            range = newRange = master.getNextBlockRange(range);
                            this.setCurrentBlockRange(stack, newRange);
                        }
                        Ritual ritual = master.getCurrentRitual();
                        List<EnumDemonWillType> willConfig = master.getActiveWillConfig();
                        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(master.getWorldObj(), master.getMasterBlockPos());
                        int maxHorizontalRange = ritual.getMaxHorizontalRadiusForRange(range, willConfig, holder);
                        int maxVerticalRange = ritual.getMaxVerticalRadiusForRange(range, willConfig, holder);
                        int maxVolume = ritual.getMaxVolumeForRange(range, willConfig, holder);
                        switch (master.setBlockRangeByBounds(player, range, containedPos, pos2)) {
                            case SUCCESS: {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.bloodmagic.blockRange.success"), true);
                                break;
                            }
                            case NOT_WITHIN_BOUNDARIES: {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.bloodmagic.blockRange.tooFar", new Object[]{maxVerticalRange, maxHorizontalRange}), false);
                                break;
                            }
                            case VOLUME_TOO_LARGE: {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.bloodmagic.blockRange.tooBig", new Object[]{maxVolume}), false);
                                break;
                            }
                            default: {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("ritual.bloodmagic.blockRange.noRange"), false);
                            }
                        }
                    }
                    this.setBlockPos(stack, BlockPos.field_177992_a);
                }
            }
        } else {
            TileEntity tile;
            EnumRitualReaderState state = this.getState(stack);
            if (state == EnumRitualReaderState.SET_AREA && (tile = world.func_175625_s(pos)) instanceof TileMasterRitualStone) {
                System.out.println("Setting range holo... I think");
                ClientHandler.setRitualRangeHolo((TileMasterRitualStone)tile, true);
            }
        }
        return super.func_195939_a(context);
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoord"), stack.func_77978_p().func_74762_e("yCoord"), stack.func_77978_p().func_74762_e("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        CompoundNBT itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoord", pos.func_177958_n());
        itemTag.func_74768_a("yCoord", pos.func_177956_o());
        itemTag.func_74768_a("zCoord", pos.func_177952_p());
        return stack;
    }

    public BlockPos getMasterBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoordmaster"), stack.func_77978_p().func_74762_e("yCoordmaster"), stack.func_77978_p().func_74762_e("zCoordmaster"));
    }

    public ItemStack setMasterBlockPos(ItemStack stack, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        CompoundNBT itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoordmaster", pos.func_177958_n());
        itemTag.func_74768_a("yCoordmaster", pos.func_177956_o());
        itemTag.func_74768_a("zCoordmaster", pos.func_177952_p());
        return stack;
    }

    public String getCurrentBlockRange(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag.func_74779_i("range");
    }

    public void setCurrentBlockRange(ItemStack stack, String range) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74778_a("range", range);
    }

    public void cycleReader(ItemStack stack, PlayerEntity player) {
        EnumRitualReaderState prevState = this.getState(stack);
        int val = prevState.ordinal();
        int nextVal = val + 1 >= EnumRitualReaderState.values().length ? 0 : val + 1;
        EnumRitualReaderState nextState = EnumRitualReaderState.values()[nextVal];
        this.setState(stack, nextState);
        this.notifyPlayerOfStateChange(nextState, player);
    }

    public void notifyPlayerOfStateChange(EnumRitualReaderState state, PlayerEntity player) {
        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("tooltip.bloodmagic.ritualReader.currentState", new Object[]{new TranslationTextComponent(tooltipBase + state.toString().toLowerCase())})});
    }

    public void setState(ItemStack stack, EnumRitualReaderState state) {
        NBTHelper.checkNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74768_a("ritualReaderState", state.ordinal());
    }

    public EnumRitualReaderState getState(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
            return EnumRitualReaderState.INFORMATION;
        }
        CompoundNBT tag = stack.func_77978_p();
        return EnumRitualReaderState.values()[tag.func_74762_e("ritualReaderState")];
    }
}

