/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wayoftime.bloodmagic.tile.TileExplosiveCharge;
import wayoftime.bloodmagic.tile.TileShapedExplosive;

public class BlockShapedExplosive
extends Block {
    private static final VoxelShape UP = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape DOWN = Block.func_208617_a((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH = Block.func_208617_a((double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)7.0);
    private static final VoxelShape EAST = Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0);
    private static final VoxelShape WEST = Block.func_208617_a((double)16.0, (double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)14.0);
    public static final EnumProperty<Direction> ATTACHED = EnumProperty.func_177709_a((String)"attached", Direction.class);
    protected final int explosionSize;

    public BlockShapedExplosive(int explosionSize, AbstractBlock.Properties properties) {
        super(properties);
        this.explosionSize = explosionSize;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(ATTACHED, (Comparable)Direction.UP));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == stateIn.func_177229_b(ATTACHED) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            Direction direction1 = direction.func_176734_d();
            if (!(blockstate = (BlockState)blockstate.func_206870_a(ATTACHED, (Comparable)direction1)).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ATTACHED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b(ATTACHED)) {
            case DOWN: {
                return DOWN;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return UP;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileShapedExplosive();
    }

    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        TileExplosiveCharge tile = (TileExplosiveCharge)world.func_175625_s(blockPos);
        if (tile != null && !world.field_72995_K) {
            tile.dropSelf();
        }
        super.func_176208_a(world, blockPos, blockState, player);
    }
}

