/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import wayoftime.bloodmagic.tile.TileAlchemyArray;
import wayoftime.bloodmagic.util.Utils;

public class BlockAlchemyArray
extends Block {
    protected static final VoxelShape BODY = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public BlockAlchemyArray() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200948_a(1.0f, 0.0f).func_200942_a());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BODY;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAlchemyArray();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAlchemyArray) {
            ((TileAlchemyArray)tile).onEntityCollidedWithBlock(state, entity);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileAlchemyArray array = (TileAlchemyArray)world.func_175625_s(pos);
        if (array == null || player.func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        ItemStack playerItem = player.func_184586_b(hand);
        if (!playerItem.func_190926_b()) {
            if (array.func_70301_a(0).func_190926_b()) {
                Utils.insertItemToTile(array, player, 0);
                world.func_184138_a(pos, state, state, 3);
            } else if (!array.func_70301_a(0).func_190926_b()) {
                Utils.insertItemToTile(array, player, 1);
                array.attemptCraft();
                world.func_184138_a(pos, state, state, 3);
            } else {
                return ActionResultType.SUCCESS;
            }
        }
        world.func_184138_a(pos, state, state, 3);
        return ActionResultType.SUCCESS;
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        TileAlchemyArray alchemyArray = (TileAlchemyArray)world.func_175625_s(blockPos);
        if (alchemyArray != null) {
            alchemyArray.dropItems();
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileAlchemyArray) {
                ((TileAlchemyArray)tileentity).dropItems();
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

