/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import wayoftime.bloodmagic.common.block.BlockMimic;
import wayoftime.bloodmagic.tile.TileMimic;

public class MimicBakedModel
implements IDynamicBakedModel {
    public final ResourceLocation texture;

    public MimicBakedModel(ResourceLocation texture) {
        this.texture = texture;
    }

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(this.texture);
    }

    public boolean func_230044_c_() {
        return false;
    }

    private void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        int tw = sprite.func_94211_a();
        int th = sprite.func_94216_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, tw, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, tw, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static Vector3d v(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        BlockState mimic = (BlockState)extraData.getData(TileMimic.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof BlockMimic)) {
            if (layer == null || RenderTypeLookup.canRenderInLayer((BlockState)mimic, (RenderType)layer)) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(mimic);
                try {
                    return model.getQuads(mimic, side, rand, (IModelData)EmptyModelData.INSTANCE);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            return Collections.emptyList();
        }
        if (side != null || layer != null && !layer.equals((Object)RenderType.func_228639_c_())) {
            return Collections.emptyList();
        }
        TextureAtlasSprite texture = this.getTexture();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double l = 0.0;
        double r = 1.0;
        quads.add(this.createQuad(MimicBakedModel.v(l, r, l), MimicBakedModel.v(l, r, r), MimicBakedModel.v(r, r, r), MimicBakedModel.v(r, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, l, l), MimicBakedModel.v(r, l, l), MimicBakedModel.v(r, l, r), MimicBakedModel.v(l, l, r), texture));
        quads.add(this.createQuad(MimicBakedModel.v(r, r, r), MimicBakedModel.v(r, l, r), MimicBakedModel.v(r, l, l), MimicBakedModel.v(r, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, r, l), MimicBakedModel.v(l, l, l), MimicBakedModel.v(l, l, r), MimicBakedModel.v(l, r, r), texture));
        quads.add(this.createQuad(MimicBakedModel.v(r, r, l), MimicBakedModel.v(r, l, l), MimicBakedModel.v(l, l, l), MimicBakedModel.v(l, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, r, r), MimicBakedModel.v(l, l, r), MimicBakedModel.v(r, l, r), MimicBakedModel.v(r, r, r), texture));
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

