/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.enums.RegionSize;
import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WaterRegionController {
    private FastNoise waterRegionController;
    private long worldSeed;
    private int dimensionID;
    private String dimensionName;
    private Random rand;
    private IBlockState lavaBlock;
    private IBlockState waterBlock;
    private float waterRegionThreshold;
    private static final float SMOOTH_RANGE = 0.04f;
    private static final float SMOOTH_DELTA = 0.01f;

    public WaterRegionController(World world, ConfigHolder config) {
        this.worldSeed = world.func_72905_C();
        this.dimensionID = world.field_73011_w.getDimension();
        this.dimensionName = world.field_73011_w.func_186058_p().toString();
        this.rand = new Random();
        this.lavaBlock = this.getLavaBlockFromString(config.lavaBlock.get());
        this.waterBlock = this.getWaterBlockFromString(config.waterBlock.get());
        this.waterRegionThreshold = NoiseUtils.simplexNoiseOffsetByPercent(-1.0f, config.waterRegionSpawnChance.get().floatValue() / 100.0f);
        float waterRegionSize = this.calcWaterRegionSize(config.waterRegionSize.get(), config.waterRegionCustomSize.get().floatValue());
        this.waterRegionController = new FastNoise();
        this.waterRegionController.SetSeed((int)world.func_72905_C() + 444);
        this.waterRegionController.SetFrequency(waterRegionSize);
    }

    public IBlockState[][] getLiquidBlocksForChunk(int chunkX, int chunkZ) {
        this.rand.setSeed(this.worldSeed ^ (long)chunkX ^ (long)chunkZ);
        IBlockState[][] blocks = new IBlockState[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int realX = chunkX * 16 + x;
                int realZ = chunkZ * 16 + z;
                BlockPos pos = new BlockPos(realX, 1, realZ);
                blocks[x][z] = this.getLiquidBlockAtPos(this.rand, pos);
            }
        }
        return blocks;
    }

    private IBlockState getLiquidBlockAtPos(Random rand, BlockPos blockPos) {
        IBlockState liquidBlock = this.lavaBlock;
        if (this.waterRegionThreshold > -1.0f) {
            float randOffset;
            float waterRegionNoise = this.waterRegionController.GetNoise(blockPos.func_177958_n(), blockPos.func_177952_p());
            if (waterRegionNoise < this.waterRegionThreshold - (randOffset = rand.nextFloat() * 0.01f + 0.04f)) {
                liquidBlock = this.waterBlock;
            } else if (waterRegionNoise < this.waterRegionThreshold + randOffset) {
                liquidBlock = null;
            }
        }
        return liquidBlock;
    }

    private IBlockState getLavaBlockFromString(String lavaString) {
        IBlockState lavaBlock;
        try {
            lavaBlock = Block.func_149684_b((String)lavaString).func_176223_P();
            BetterCaves.LOGGER.info("Using block '" + lavaString + "' as lava in cave generation for dimension " + BetterCavesUtils.dimensionAsString(this.dimensionID, this.dimensionName) + " ...");
        }
        catch (Exception e) {
            BetterCaves.LOGGER.warn("Unable to use block '" + lavaString + "': " + e);
            BetterCaves.LOGGER.warn("Using vanilla lava instead...");
            lavaBlock = Blocks.field_150353_l.func_176223_P();
        }
        if (lavaBlock == null) {
            BetterCaves.LOGGER.warn("Unable to use block '" + lavaString + "': null block returned.\n Using vanilla lava instead...");
            lavaBlock = Blocks.field_150353_l.func_176223_P();
        }
        return lavaBlock;
    }

    private IBlockState getWaterBlockFromString(String waterString) {
        IBlockState waterBlock;
        try {
            waterBlock = Block.func_149684_b((String)waterString).func_176223_P();
            BetterCaves.LOGGER.info("Using block '" + waterString + "' as water in cave generation for dimension " + BetterCavesUtils.dimensionAsString(this.dimensionID, this.dimensionName) + " ...");
        }
        catch (Exception e) {
            BetterCaves.LOGGER.warn("Unable to use block '" + waterString + "': " + e);
            BetterCaves.LOGGER.warn("Using vanilla water instead...");
            waterBlock = Blocks.field_150355_j.func_176223_P();
        }
        if (waterBlock == null) {
            BetterCaves.LOGGER.warn("Unable to use block '" + waterString + "': null block returned.\n Using vanilla water instead...");
            waterBlock = Blocks.field_150355_j.func_176223_P();
        }
        return waterBlock;
    }

    private float calcWaterRegionSize(RegionSize waterRegionSize, float waterRegionCustomSize) {
        switch (waterRegionSize) {
            case Small: {
                return 0.008f;
            }
            case Large: {
                return 0.0028f;
            }
            case ExtraLarge: {
                return 0.001f;
            }
            case Custom: {
                return waterRegionCustomSize;
            }
        }
        return 0.004f;
    }
}

