/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pregenerator.impl.misc.BoundingBox;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureController;
import pregenerator.impl.structure.StructureData;

public class StructureManager {
    public static StructureManager instance = new StructureManager();
    Map<World, StructureController> controller = new LinkedHashMap<World, StructureController>();
    Map<Integer, Set<String>> types = new HashMap<Integer, Set<String>>();
    List<String> allTypes = null;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onServerStopped() {
        for (StructureController entry : this.controller.values()) {
            entry.cleanup();
        }
        this.controller.clear();
        this.allTypes = null;
    }

    public Set<String> getTypes(int dimension) {
        Set<String> set = this.types.get(dimension);
        if (set == null) {
            set = new HashSet<String>();
        }
        return set;
    }

    public Map<String, List<BoundingBox>> getBoxes() {
        LinkedHashMap<String, List<BoundingBox>> map = new LinkedHashMap<String, List<BoundingBox>>();
        for (StructureController entry : this.controller.values()) {
            map.putAll(entry.getStorage().getBoxes());
        }
        return map;
    }

    public Map<String, List<BoundingBox>> getBoxes(int dimension) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        LinkedHashMap<String, List<BoundingBox>> boxes = new LinkedHashMap<String, List<BoundingBox>>();
        if (control != null) {
            boxes.putAll(control.getStorage().getBoxes());
        }
        return boxes;
    }

    public List<BoundingBox> getBoxes(int dimension, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        if (control != null) {
            return control.getStorage().getBoxes(type);
        }
        return new ArrayList<BoundingBox>();
    }

    public List<String> generateAllTypes() {
        if (this.allTypes == null) {
            this.allTypes = new ArrayList<String>();
            for (Set<String> set : this.types.values()) {
                this.allTypes.addAll(set);
            }
        }
        return this.allTypes;
    }

    public List<String> getAllTypes(int world) {
        Set<String> set = this.types.get(world);
        if (set == null || set.isEmpty()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(set);
    }

    public List<String> getDims() {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer data : this.types.keySet()) {
            list.add(data.toString());
        }
        return list;
    }

    public List<StructureData> getStructures(int dim) {
        ArrayList<StructureData> list = new ArrayList<StructureData>();
        StructureController cont = this.controller.get(DimensionManager.getWorld((int)dim));
        if (cont != null) {
            cont.addStructures(list);
        }
        return list;
    }

    public List<String> getXPositions(int dim, String type) {
        MapGenStructureDataPregen data;
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null && (data = control.getStructure(type)) != null) {
            ArrayList<String> s = new ArrayList<String>();
            for (StructureStart start : data.getStarts()) {
                s.add(start.func_143019_e() + "");
            }
            return s;
        }
        return new ArrayList<String>();
    }

    public List<String> getZPositions(int dim, String type, int x) {
        MapGenStructureDataPregen data;
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null && (data = control.getStructure(type)) != null) {
            ArrayList<String> s = new ArrayList<String>();
            for (StructureStart start : data.getStarts()) {
                if (start.func_143019_e() != x) continue;
                s.add(start.func_143018_f() + "");
            }
            return s;
        }
        return new ArrayList<String>();
    }

    public boolean validateType(int dim, String type) {
        if (type.equalsIgnoreCase("All")) {
            return true;
        }
        Set<String> set = this.types.get(dim);
        if (set == null) {
            return false;
        }
        return set.contains(type);
    }

    public void register(World world, String type) {
        Set<String> set = this.types.get(world.field_73011_w.getDimension());
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.types.put(world.field_73011_w.getDimension(), set);
        }
        set.add(type);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        this.controller.put(world, new StructureController(world));
        this.allTypes = null;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        StructureController control = this.controller.remove(event.getWorld());
        if (control != null) {
            control.cleanup();
            this.allTypes = null;
        }
    }

    @SubscribeEvent
    public void onPopulation(PopulateChunkEvent.Pre event) {
        StructureController control = this.controller.get(event.getWorld());
        if (control != null) {
            control.onPopulation();
        }
    }

    public void createSaveZone(int x, int z, int radius, String type, int dimension) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dimension));
        if (control != null) {
            control.addSaveZone(type, x, z, radius, radius);
        }
    }

    public boolean clearZoneAt(int index, int dim, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null) {
            return control.getStorage().removeAt(index, type);
        }
        return false;
    }

    public boolean clearZoneLast(int dim, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null) {
            return control.getStorage().removeLast(type);
        }
        return false;
    }

    public void clearAllZones(int dim, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null) {
            control.getStorage().clearAll(type);
        }
    }

    public void clearAllZones() {
        for (StructureController control : this.controller.values()) {
            control.getStorage().clearAll();
        }
    }

    public MapGenStructureDataPregen getStructure(int dim, String type) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null) {
            return control.getStructure(type);
        }
        return null;
    }

    public List<MapGenStructureDataPregen> getStructureHolders(int dim) {
        StructureController control = this.controller.get(DimensionManager.getWorld((int)dim));
        if (control != null) {
            return control.getStructures();
        }
        return new ArrayList<MapGenStructureDataPregen>();
    }
}

