/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.structure;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import pregenerator.impl.misc.BoundingBox;

public class SaveZoneData
extends WorldSavedData {
    Map<String, List<BoundingBox>> saveZones = new LinkedHashMap<String, List<BoundingBox>>();

    public SaveZoneData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.saveZones.clear();
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            NBTTagList dataList = data.func_150295_c("Value", 11);
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            for (int x = 0; x < dataList.func_74745_c(); ++x) {
                boxes.add(new BoundingBox(dataList.func_150306_c(x)));
            }
            this.saveZones.put(data.func_74779_i("ID"), boxes);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, List<BoundingBox>> entry : this.saveZones.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("ID", entry.getKey());
            NBTTagList dataList = new NBTTagList();
            for (BoundingBox box : entry.getValue()) {
                dataList.func_74742_a((NBTBase)box.write());
            }
            data.func_74782_a("Value", (NBTBase)dataList);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
        return nbt;
    }

    public void addSaveZone(String type, BoundingBox box) {
        List<BoundingBox> boxes = this.saveZones.get(type);
        if (boxes == null) {
            boxes = new ArrayList<BoundingBox>();
            this.saveZones.put(type, boxes);
        }
        boxes.add(box);
        this.func_76185_a();
    }

    public boolean contains(String type, int x, int z) {
        List<BoundingBox> boxes = this.saveZones.get(type);
        if (boxes == null) {
            return false;
        }
        for (BoundingBox box : boxes) {
            if (!box.isInsideBox(x, z)) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<BoundingBox>> getBoxes() {
        return this.saveZones;
    }

    public List<BoundingBox> getBoxes(String type) {
        List<BoundingBox> box = this.saveZones.get(type);
        if (box == null) {
            box = new ArrayList<BoundingBox>();
        }
        return box;
    }

    public boolean removeAt(int index, String type) {
        List<BoundingBox> box = this.saveZones.get(type);
        if (box == null || index < 0 || index >= box.size()) {
            return false;
        }
        box.remove(index);
        this.func_76185_a();
        return true;
    }

    public boolean removeLast(String type) {
        List<BoundingBox> box = this.saveZones.get(type);
        if (box == null || box.isEmpty()) {
            return false;
        }
        box.remove(box.size() - 1);
        this.func_76185_a();
        return true;
    }

    public void clearAll() {
        this.saveZones.clear();
        this.func_76185_a();
    }

    public void clearAll(String type) {
        if (type.equalsIgnoreCase("All")) {
            this.clearAll();
        } else if (this.saveZones.remove(type) != null) {
            this.func_76185_a();
        }
    }
}

