/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo.detailed;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.detailed.DetailedEntry;
import pregenerator.impl.tracking.WorldTracker;

public class TileEntities
extends DetailedEntry {
    int tile;
    int tickingTile;

    public TileEntities() {
        this.register();
    }

    @Override
    public String getName() {
        return "TileEntities";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        WorldTracker tracker = this.getWorld();
        buf.writeInt(tracker != null ? tracker.getLoadedTileEntities() : 0);
        buf.writeInt(tracker != null ? tracker.getTickingTileEntities() : 0);
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        this.tile = buf.readInt();
        this.tickingTile = buf.readInt();
    }

    @Override
    public int getYOffset() {
        return 12;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        helper.renderText(x - (width - 25), y, width, "LoadedTileEntities: " + this.tile);
        helper.renderText(x - (width - 25), y += 6, width, "TickingTileEntities: " + this.tickingTile);
    }
}

