/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.TrackerEntry;

public class RamUsage
extends TrackerEntry {
    int min;
    int max;

    public RamUsage() {
        this.register();
    }

    @Override
    public String getName() {
        return "ServerRam";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        Runtime time = Runtime.getRuntime();
        buf.writeInt(this.toMB(time.totalMemory() - time.freeMemory()));
        buf.writeInt(this.toMB(time.maxMemory()));
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        this.min = buf.readInt();
        this.max = buf.readInt();
    }

    @Override
    public int currentValue() {
        return this.min;
    }

    @Override
    public int maxValue() {
        return this.max;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int progresBar = (int)(progress * (float)width);
        helper.renderBar(x - width / 2, y, width, progresBar, "ServerRam: " + this.min + "/" + this.max + " MB");
    }

    private int toMB(long input) {
        return (int)(input / 1024L / 1024L);
    }
}

