/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.BaseChunkData;

public class ChunkData
extends BaseChunkData {
    int[] originalBlockColors = new int[0];
    int[] blockColors = new int[256];
    int[] biomeIDs = new int[256];
    int[] biomeGrassColor = new int[256];
    int[] biomeFoliageColor = new int[256];

    protected ChunkData() {
    }

    public ChunkData(Chunk chunk) {
        super(chunk);
        this.originalBlockColors = new int[256];
        World world = chunk.func_177412_p();
        int xPos = chunk.field_76635_g * 16;
        int zPos = chunk.field_76647_h * 16;
        int heighest = chunk.func_76625_h() + 16;
        int left = Math.abs(heighest - chunk.func_177412_p().field_73011_w.getActualHeight());
        if (heighest <= 5 || !chunk.func_177412_p().field_73011_w.func_191066_m()) {
            heighest = chunk.func_177412_p().func_181545_F() + 1;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.func_181079_c(xPos + x, 64, zPos + z);
                Biome biome = chunk.func_177411_a((BlockPos)pos, world.func_72959_q());
                int grass = biome.func_180627_b((BlockPos)pos);
                int foliage = biome.func_180625_c((BlockPos)pos);
                pos.func_185336_p(heighest);
                this.getFirstBlock(chunk, pos);
                int index = z * 16 + x;
                IBlockState state = chunk.func_177435_g((BlockPos)pos);
                MapColor map = state.func_185909_g((IBlockAccess)world, (BlockPos)pos);
                this.blockColors[index] = map.func_151643_b(0);
                this.originalBlockColors[index] = this.blockColors[index];
                this.biomeFoliageColor[index] = foliage;
                this.biomeGrassColor[index] = grass;
                this.biomeIDs[index] = Biome.func_185362_a((Biome)biome);
                pos.func_185336_p(heighest);
                this.heightMap[index] = this.getHeightMapHeight(chunk, pos);
            }
        }
    }

    public static ChunkData createDataFromBuffer(ByteBuffer chunkData, ByteBuffer heightData) throws Exception {
        int i;
        ChunkData data = new ChunkData();
        data.chunkX = chunkData.getInt();
        data.chunkZ = chunkData.getInt();
        data.slimeChunk = chunkData.get() == 1;
        for (i = 0; i < 256; ++i) {
            data.blockColors[i] = chunkData.getInt();
        }
        for (i = 0; i < 256; ++i) {
            data.biomeIDs[i] = chunkData.getShort();
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.func_181079_c(data.chunkX * 16 + x, 64, data.chunkZ * 16 + z);
                Biome subBiome = data.getBiome(data.biomeIDs[z << 4 | x]);
                data.biomeFoliageColor[z << 4 | x] = subBiome.func_180625_c((BlockPos)pos);
                data.biomeGrassColor[z << 4 | x] = subBiome.func_180627_b((BlockPos)pos);
            }
        }
        if (heightData.get() <= 0) {
            data.heightMap = new int[0];
        } else {
            for (int i2 = 0; i2 < data.heightMap.length; ++i2) {
                data.heightMap[i2] = heightData.get() + 128;
            }
        }
        return data;
    }

    public int[] getData(int view) {
        switch (view) {
            case 1: {
                return this.biomeFoliageColor;
            }
            case 2: {
                return this.biomeGrassColor;
            }
        }
        return this.blockColors;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomeIDs[z * 16 + x];
    }

    @Override
    public void addToTexture(MoveableTexture texture, int view, int size) {
        texture.addChunkData(this, size, view);
    }

    @Override
    public void updateHeightMap(IHeightMap map) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = this.chunkX * 16 + x;
                int zPos = this.chunkZ * 16 + z;
                int index = z * 16 + x;
                if (this.isDarker(xPos, zPos, map)) {
                    this.blockColors[index] = ChunkData.darker(this.originalBlockColors[index], 0.8f);
                    continue;
                }
                if (!this.isBrigther(xPos, zPos, map)) continue;
                this.blockColors[index] = ChunkData.brighter(this.originalBlockColors[index], 0.8f);
            }
        }
    }

    @Override
    public void storeInHeightMap(IHeightMap map) {
        map.storeHeightData(this.chunkX, this.chunkZ, this.heightMap);
    }

    @Override
    public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate((int)IFileProvider.FileType.Chunk_Data.getOffset());
        buffer.put((byte)1);
        buffer.putInt(this.chunkX).putInt(this.chunkZ);
        buffer.put((byte)(this.slimeChunk ? 1 : 0));
        for (i = 0; i < 256; ++i) {
            buffer.putInt(this.blockColors[i]);
        }
        for (i = 0; i < 256; ++i) {
            buffer.putShort((short)this.biomeIDs[i]);
        }
        chunkData.seek(provider.getOrCreateIndex(this.chunkX, this.chunkZ, IFileProvider.FileType.Chunk_Data));
        chunkData.write(buffer.array());
        buffer = ByteBuffer.allocate((int)IFileProvider.FileType.HeightData.getOffset());
        buffer.put((byte)1);
        for (i = 0; i < this.heightMap.length; ++i) {
            buffer.put((byte)(this.heightMap[i] - 128));
        }
        heightData.seek(provider.getOrCreateIndex(this.chunkX, this.chunkZ, IFileProvider.FileType.HeightData));
        heightData.write(buffer.array());
    }
}

