/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;
import pregenerator.ChunkPregenerator;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.client.gui.GuiPregenMenu;
import pregenerator.impl.client.gui.GuiTypeInfo;
import pregenerator.impl.client.gui.GuiWorldStuff;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.network.packets.DimRequestPacket;
import pregenerator.impl.network.packets.chunkRequest.ChunkRequest;
import pregenerator.impl.network.packets.chunkRequest.TPChunkPacket;
import pregenerator.impl.tracking.ChunkEntry;

public class GuiChunkInfo
extends GuiPregenBase {
    public static final GuiChunkInfo INSTANCE = new GuiChunkInfo();
    DecimalFormat format = InfoEntry.FORMAT;
    public final SelectionList<Comparator<ChunkEntry>> comparators = new SelectionList<Comparator<ChunkEntry>>(this.createList());
    public final List<String> comparatorNames = Arrays.asList("Distance", "EntityCount", "TileCount", "TickingTileCount", "RandomUpdates");
    int ticker;
    int answerType = -1;
    int packetsLeft = 0;
    SelectionList<Integer> dimensions = new SelectionList();
    SelectionList<ChunkEntry> chunks = new SelectionList().setNoLoop();

    public void openUI() {
        ChunkPregenerator.networking.sendPacketToServer(new DimRequestPacket(1));
        this.ticker = 0;
    }

    public void onCleared() {
        this.answerType = -1;
        this.packetsLeft = 0;
        this.comparators.setIndex(0);
        this.dimensions.clear();
        this.chunks.clear();
    }

    public void addChunks(List<ChunkEntry> list, int left) {
        this.chunks.addValues(list);
        this.packetsLeft = left;
        this.answerType = 1;
        if (this.packetsLeft == 0) {
            this.answerType = 2;
            Collections.sort(this.chunks.getValues(), this.comparators.getValue());
            this.chunks.setIndex(0);
        }
    }

    public void noDataFound() {
        this.answerType = -2;
        this.ticker = 0;
    }

    public void addDims(List<Integer> list) {
        Integer last = this.dimensions.getValue();
        boolean wasEmpty = this.dimensions.size() <= 0;
        this.dimensions.setValues(list);
        if (wasEmpty) {
            this.dimensions.setIndexFromValue(0);
        }
        if (last != this.dimensions.getValue()) {
            this.chunks.clear();
        }
    }

    public int getDimension() {
        Integer value = this.dimensions.getValue();
        return value == null ? 0 : value;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int id = button.field_146127_k;
        if (id == 2) {
            this.openUI();
        } else if (id == 0) {
            if (GuiChunkInfo.func_146272_n()) {
                this.dimensions.prev();
                this.chunks.clear();
            } else {
                this.dimensions.next();
                this.chunks.clear();
            }
        } else if (id == 1) {
            this.chunks.clear();
            if (GuiChunkInfo.func_146272_n()) {
                this.answerType = -1;
            } else {
                ChunkPregenerator.networking.sendPacketToServer(new ChunkRequest(this.getDimension()));
                this.answerType = 0;
            }
        } else if (id == 3) {
            this.chunks.next();
        } else if (id == 4) {
            this.chunks.prev();
        } else if (id == 5) {
            if (GuiChunkInfo.func_146272_n()) {
                this.comparators.prev();
                Collections.sort(this.chunks.getValues(), this.comparators.getValue());
                this.chunks.setIndex(0);
            } else {
                this.comparators.next();
                Collections.sort(this.chunks.getValues(), this.comparators.getValue());
                this.chunks.setIndex(0);
            }
        } else if (id == 6) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldStuff(new GuiPregenMenu()));
        } else if (id >= 10) {
            int index = (id -= 10) / 4;
            int buttonID = id % 4;
            ChunkEntry entry = this.chunks.getValue(this.chunks.getIndex() + index);
            if (entry == null) {
                return;
            }
            if (buttonID == 0 || buttonID == 1 || buttonID == 2) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiTypeInfo(entry, buttonID));
            } else if (buttonID == 3) {
                this.field_146297_k.func_147108_a(null);
                ChunkPregenerator.networking.sendPacketToServer(new TPChunkPacket(entry.getPos()));
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerButton(0, -130, -118, 95, 20, "Dim: " + this.getDimension());
        this.registerButton(1, -130, -97, 40, 20, GuiChunkInfo.func_146272_n() ? "Clear" : "Reload");
        this.registerButton(2, -35, -118, 60, 20, "Reload Dim");
        this.registerButton(3, 150, -97, 20, 20, "+");
        this.registerButton(4, 129, -97, 20, 20, "-");
        this.registerButton(5, 26, -118, 130, 20, "Sorter: " + this.comparatorNames.get(this.comparators.getIndex()));
        this.registerButton(6, 68, -97, 60, 20, "Back");
        int offset = 52;
        int index = 10;
        for (int i = 0; i < 3 && i + this.chunks.getIndex() < this.chunks.size(); ++i) {
            this.registerButton(index, 105, -offset, 60, 20, "Entities");
            this.registerButton(index + 1, 105, -offset + 25, 60, 20, "TileEntities");
            this.registerButton(index + 2, 40, -offset, 60, 20, "Biomes");
            this.registerButton((int)(index + 3), (int)40, (int)(-offset + 25), (int)60, (int)20, (String)"Teleport").field_146124_l = this.field_146297_k.field_71439_g.field_71093_bK == this.getDimension();
            offset -= 60;
            index += 4;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int effect = Mouse.getDWheel() / 120;
        this.chunks.setIndex(this.chunks.getIndex() - effect * (GuiScreen.func_146271_m() ? 10 : 1));
        this.func_73866_w_();
        ++this.ticker;
        this.func_146276_q_();
        this.drawRectangle(160, 120, 20, 0, -3750202, false);
        int data = -33;
        boolean shift = GuiChunkInfo.func_146272_n();
        int drawn = 0;
        for (int i = 0; i < 3 && i + this.chunks.getIndex() < this.chunks.size(); ++i) {
            this.drawRectangle(150, 28, 20, data, -7631989, true);
            data += 60;
            ++drawn;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawLeftText(this.chunks.getIndex() + "/" + this.chunks.size(), 170, -70, 0x404040);
        if (this.answerType == -1) {
            this.drawText("<-- Require Reloading", -85, -90, 0x404040);
        } else if (this.answerType == -2) {
            this.drawText("No Chunks Found", -85, -90, 0x404040);
            if (this.ticker >= 200) {
                this.answerType = 2;
            }
        } else if (this.answerType == 1) {
            this.drawText("Awaiting Packets: " + this.packetsLeft, -85, -90, 0x404040);
        } else if (this.answerType != 2) {
            this.drawText("Reloading: ", -85, -90, 0x404040);
            StringBuilder build = new StringBuilder();
            int index = this.ticker / 20 % 5;
            for (int i = 0; i < 5; ++i) {
                if (i == index) {
                    build.append("O");
                    continue;
                }
                build.append("o");
            }
            this.drawText(build.toString(), -33, -90, 0x404040);
        }
        int yOffset = 60;
        for (int i = 0; i < drawn; ++i) {
            this.drawData(yOffset, i, shift);
            yOffset -= 60;
        }
    }

    private void drawData(int yOffset, int index, boolean shift) {
        ChunkEntry entry = this.chunks.getValue(this.chunks.getIndex() + index);
        if (entry == null) {
            return;
        }
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (shift) {
            FilePos pos = new FilePos((int)player.field_70165_t, (int)player.field_70161_v);
            this.drawText("BlockX: " + this.format.format(entry.xPos * 16), -128, -yOffset, 0x404040);
            this.drawText("BlockZ: " + this.format.format(entry.zPos * 16), -128, -yOffset + 9, 0x404040);
            this.drawText("Dist: " + this.format.format(pos.getSqDistance(entry.xPos * 16, entry.zPos * 16)) + " B", -28, -yOffset, 0x404040);
        } else {
            FilePos pos = new FilePos((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
            this.drawText("ChunkX: " + this.format.format(entry.xPos), -128, -yOffset, 0x404040);
            this.drawText("ChunkZ: " + this.format.format(entry.zPos), -128, -yOffset + 9, 0x404040);
            this.drawText("Dist: " + this.format.format(pos.getSqDistance(entry.xPos, entry.zPos)) + " C", -28, -yOffset, 0x404040);
        }
        this.drawText("Loaded Entities: " + this.format.format(entry.entities), -128, -yOffset + 18, 0x404040);
        this.drawText("Loaded TileEntities: " + this.format.format(entry.tileEntities), -128, -yOffset + 27, 0x404040);
        this.drawText("Ticking TileEntities: " + this.format.format(entry.tickableTileEntities), -128, -yOffset + 36, 0x404040);
        this.drawText("Random Tick Blocks: " + this.format.format(entry.randomUpdateBlocks), -128, -yOffset + 45, 0x404040);
    }

    public boolean func_73868_f() {
        return false;
    }

    public List<Comparator<ChunkEntry>> createList() {
        ArrayList<Comparator<ChunkEntry>> list = new ArrayList<Comparator<ChunkEntry>>();
        list.add(new Comparator<ChunkEntry>(){

            @Override
            public int compare(ChunkEntry o1, ChunkEntry o2) {
                int secondDistance;
                int firstDistance = this.getDistance(o1.getPos());
                if (firstDistance > (secondDistance = this.getDistance(o2.getPos()))) {
                    return -1;
                }
                if (secondDistance > firstDistance) {
                    return 1;
                }
                return 0;
            }

            public int getDistance(FilePos pos) {
                EntityPlayerSP player = GuiChunkInfo.this.field_146297_k.field_71439_g;
                return pos.getDistance((int)player.field_70165_t, (int)player.field_70161_v);
            }
        });
        list.add(new Comparator<ChunkEntry>(){

            @Override
            public int compare(ChunkEntry o1, ChunkEntry o2) {
                if (o1.entities > o2.entities) {
                    return -1;
                }
                if (o2.entities > o1.entities) {
                    return 1;
                }
                return 0;
            }
        });
        list.add(new Comparator<ChunkEntry>(){

            @Override
            public int compare(ChunkEntry o1, ChunkEntry o2) {
                if (o1.tileEntities > o2.tileEntities) {
                    return -1;
                }
                if (o2.tileEntities > o1.tileEntities) {
                    return 1;
                }
                return 0;
            }
        });
        list.add(new Comparator<ChunkEntry>(){

            @Override
            public int compare(ChunkEntry o1, ChunkEntry o2) {
                if (o1.tickableTileEntities > o2.tickableTileEntities) {
                    return -1;
                }
                if (o2.tickableTileEntities > o1.tickableTileEntities) {
                    return 1;
                }
                return 0;
            }
        });
        list.add(new Comparator<ChunkEntry>(){

            @Override
            public int compare(ChunkEntry o1, ChunkEntry o2) {
                if (o1.randomUpdateBlocks > o2.randomUpdateBlocks) {
                    return -1;
                }
                if (o2.randomUpdateBlocks > o1.randomUpdateBlocks) {
                    return 1;
                }
                return 0;
            }
        });
        return list;
    }
}

