/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.item;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.SimpleArmorItemData;

@SideOnly(value=Side.CLIENT)
public class SimpleItemData
implements IItemData {
    public static final Reference2ObjectOpenHashMap<ItemClass, SimpleItemData> CACHE = new Reference2ObjectOpenHashMap();
    protected final ItemClass itemClass;

    public SimpleItemData(@Nonnull ItemClass ic) {
        this.itemClass = ic;
    }

    @Override
    @Nonnull
    public ItemClass getItemClass() {
        return this.itemClass;
    }

    @Override
    @Nullable
    public SoundEffect getEquipSound(@Nonnull ItemStack stack) {
        return this.itemClass.getEquipSound();
    }

    @Override
    @Nullable
    public SoundEffect getSwingSound(@Nonnull ItemStack stack) {
        return this.itemClass.getSwingSound();
    }

    @Override
    @Nullable
    public SoundEffect getUseSound(@Nonnull ItemStack stack) {
        return this.itemClass.getUseSound();
    }

    static {
        for (ItemClass ic : ItemClass.values()) {
            if (ic.isArmor()) {
                CACHE.put((Object)ic, (Object)new SimpleArmorItemData(ic));
                continue;
            }
            CACHE.put((Object)ic, (Object)new SimpleItemData(ic));
        }
    }
}

