/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.orecruncher.dsurround.event.BlockUpdateEvent;
import org.orecruncher.dsurround.lib.scanner.ComplementsPointIterator;
import org.orecruncher.dsurround.lib.scanner.Cuboid;
import org.orecruncher.dsurround.lib.scanner.CuboidPointIterator;
import org.orecruncher.dsurround.lib.scanner.ScanLocus;
import org.orecruncher.dsurround.lib.scanner.Scanner;
import org.orecruncher.lib.chunk.IBlockAccessEx;

public abstract class CuboidScanner
extends Scanner {
    protected boolean scanFinished = false;
    protected Cuboid activeCuboid;
    protected CuboidPointIterator fullRange;
    protected BlockPos lastPos;
    protected int lastReference = 0;

    protected CuboidScanner(@Nonnull ScanLocus locus, @Nonnull String name, int range, int blocksPerTick) {
        super(locus, name, range, blocksPerTick);
    }

    protected CuboidScanner(@Nonnull ScanLocus locus, @Nonnull String name, int xRange, int yRange, int zRange) {
        super(locus, name, xRange, yRange, zRange);
    }

    protected CuboidScanner(@Nonnull ScanLocus locus, @Nonnull String name, int xSize, int ySize, int zSize, int blocksPerTick) {
        super(locus, name, xSize, ySize, zSize, blocksPerTick);
    }

    public boolean isScanFinished() {
        return this.scanFinished;
    }

    protected BlockPos[] getMinMaxPointsForVolume(@Nonnull BlockPos pos) {
        BlockPos min = pos.func_177982_a(-this.xRange, -this.yRange, -this.zRange);
        BlockPos max = pos.func_177982_a(this.xRange, this.yRange, this.zRange);
        if (min.func_177956_o() < 0) {
            min = new BlockPos(min.func_177958_n(), 0, min.func_177952_p());
        }
        return new BlockPos[]{min, max};
    }

    protected Cuboid getVolumeFor(BlockPos pos) {
        BlockPos[] points = this.getMinMaxPointsForVolume(pos);
        return new Cuboid(points);
    }

    protected void resetFullScan() {
        this.lastPos = this.locus.getCenter();
        this.lastReference = this.locus.getReference();
        this.scanFinished = false;
        BlockPos[] points = this.getMinMaxPointsForVolume(this.lastPos);
        this.activeCuboid = new Cuboid(points);
        this.fullRange = new CuboidPointIterator(points);
    }

    @Override
    public void func_73660_a() {
        BlockPos playerPos = this.locus.getCenter();
        if (playerPos == null || playerPos.func_177956_o() < 0) {
            this.fullRange = null;
        } else if (this.fullRange == null || this.locus.getReference() != this.lastReference) {
            this.resetFullScan();
            super.func_73660_a();
        } else if (this.lastPos.equals((Object)playerPos)) {
            if (!this.scanFinished) {
                super.func_73660_a();
            }
        } else {
            Cuboid newVolume;
            Cuboid oldVolume = this.activeCuboid != null ? this.activeCuboid : this.getVolumeFor(this.lastPos);
            Cuboid intersect = oldVolume.intersection(newVolume = this.getVolumeFor(playerPos));
            if (intersect == null || oldVolume.volume() < (oldVolume.volume() - intersect.volume()) * 2L) {
                this.resetFullScan();
                super.func_73660_a();
            } else if (this.scanFinished) {
                this.lastPos = playerPos;
                this.activeCuboid = newVolume;
                this.updateScan(newVolume, oldVolume, intersect);
            } else {
                super.func_73660_a();
            }
        }
    }

    public boolean doBlockUnscan() {
        return false;
    }

    public void blockUnscan(IBlockState state, BlockPos pos, Random rand) {
    }

    protected void updateScan(@Nonnull Cuboid newVolume, @Nonnull Cuboid oldVolume, @Nonnull Cuboid intersect) {
        IBlockState state;
        BlockPos point;
        IBlockAccessEx provider = this.locus.getWorld();
        if (this.doBlockUnscan()) {
            ComplementsPointIterator newOutOfRange = new ComplementsPointIterator(oldVolume, intersect);
            point = newOutOfRange.next();
            while (point != null) {
                if (point.func_177956_o() > 0 && this.interestingBlock(state = provider.func_180495_p(point))) {
                    this.blockUnscan(state, point, this.random);
                }
                point = newOutOfRange.next();
            }
        }
        ComplementsPointIterator newInRange = new ComplementsPointIterator(newVolume, intersect);
        point = newInRange.next();
        while (point != null) {
            if (point.func_177956_o() > 0 && this.interestingBlock(state = provider.func_180495_p(point))) {
                this.blockScan(state, point, this.random);
            }
            point = newInRange.next();
        }
        this.scanFinished = true;
    }

    @Override
    @Nullable
    protected BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos workingPos, @Nonnull Random rand) {
        if (this.scanFinished) {
            return null;
        }
        IBlockAccessEx provider = this.locus.getWorld();
        int checked = 0;
        BlockPos point = null;
        while ((point = this.fullRange.peek()) != null) {
            if (!provider.isAvailable(point)) {
                return null;
            }
            this.fullRange.next();
            if (point.func_177956_o() > 0) {
                return point;
            }
            if (++checked < this.blocksPerTick) continue;
            return null;
        }
        this.scanFinished = true;
        return null;
    }

    protected boolean isInteresting(@Nonnull BlockUpdateEvent event) {
        if (this.activeCuboid == null || event.oldState == event.newState) {
            return false;
        }
        if (!this.activeCuboid.contains(event.pos)) {
            return false;
        }
        if (!this.interestingBlock(event.newState)) {
            return false;
        }
        return this.locus.getWorld().isAvailable(event.pos);
    }

    @SubscribeEvent(receiveCanceled=false)
    public void onBlockUpdate(@Nonnull BlockUpdateEvent event) {
        try {
            if (this.isInteresting(event)) {
                this.blockScan(event.newState, event.pos, this.random);
            }
        }
        catch (Throwable t) {
            this.log.error("onBlockUpdate() error", t);
        }
    }
}

