/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather.compat;

import java.lang.reflect.Method;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;

@SideOnly(value=Side.CLIENT)
public final class RandomThings {
    private static Method shouldRain;

    private RandomThings() {
    }

    public static boolean shouldRain(World world, BlockPos pos) {
        if (shouldRain == null) {
            return true;
        }
        try {
            return (Boolean)shouldRain.invoke(null, world, pos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ModBase.log().warn("Exception checking rain shield!", new Object[0]);
            shouldRain = null;
            return true;
        }
    }

    static {
        try {
            Class<?> rtClass = Class.forName("lumien.randomthings.tileentity.TileEntityRainShield");
            shouldRain = ReflectionHelper.findMethod(rtClass, (String)"shouldRain", null, (Class[])new Class[]{World.class, BlockPos.class});
            if (shouldRain != null) {
                ModBase.log().info("RandomThings rain shield detected!", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

