/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.renderer;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class BadgeRenderLayer
implements LayerRenderer<EntityLivingBase> {
    private static final float CONST = 2.8647888f;
    protected final IShowBadge displayCheck;
    protected final IItemStackProvider stackProvider;

    public BadgeRenderLayer(@Nonnull IShowBadge check, @Nonnull IItemStackProvider provider) {
        this.displayCheck = check;
        this.stackProvider = provider;
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!this.displayCheck.showBadge()) {
            return;
        }
        double distSq = ModOptions.effects.specialEffectRange * ModOptions.effects.specialEffectRange;
        if (entity.func_70068_e((Entity)EnvironStateHandler.EnvironState.getPlayer()) > distSq) {
            return;
        }
        ItemStack stackToRender = this.stackProvider.getStackToDisplay(entity);
        if (stackToRender.func_190926_b()) {
            return;
        }
        float age = (float)entity.field_70173_aa + partialTicks;
        float s = 0.6f;
        float dY = this.stackProvider.adjustY() + entity.field_70131_O - 0.15f + MathStuff.sin((float)(age / 20.0f)) / 3.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        GlStateManager.func_179114_b((float)(age * 2.8647888f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)dY, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stackToRender, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }

    public static interface IItemStackProvider {
        @Nonnull
        public ItemStack getStackToDisplay(@Nonnull EntityLivingBase var1);

        default public float adjustY() {
            return 0.0f;
        }
    }

    public static interface IShowBadge {
        public boolean showBadge();
    }
}

