/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.scanners;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityData;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;

@SideOnly(value=Side.CLIENT)
public class BattleScanner
implements ITickable {
    private static final int BOSS_RANGE = 65536;
    private static final int MINI_BOSS_RANGE = 16384;
    private static final int MOB_RANGE = 400;
    private static final int BATTLE_TIMER_EXPIRY = 10;
    protected int battleTimer;
    protected boolean inBattle;
    protected boolean isWither;
    protected boolean isDragon;
    protected boolean isBoss;

    public void reset() {
        this.inBattle = false;
        this.isWither = false;
        this.isDragon = false;
        this.isBoss = false;
    }

    public boolean inBattle() {
        return this.inBattle;
    }

    public boolean isWither() {
        return this.isWither;
    }

    public boolean isDragon() {
        return this.isDragon;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    private boolean isApplicableType(Entity e) {
        if (e instanceof IMob) {
            return true;
        }
        if (e instanceof EntityPlayer) {
            return true;
        }
        if (e instanceof EntityGolem) {
            return true;
        }
        return e instanceof EntityPolarBear;
    }

    public void func_73660_a() {
        if (!ModOptions.sound.enableBattleMusic) {
            this.isWither = false;
            this.isDragon = false;
            this.isBoss = false;
            this.inBattle = false;
            return;
        }
        EntityPlayer player2 = EnvironStateHandler.EnvironState.getPlayer();
        BlockPos playerPos = EnvironStateHandler.EnvironState.getPlayerPosition();
        World world = EnvironStateHandler.EnvironState.getWorld();
        boolean inBattle = false;
        boolean isBoss = false;
        boolean isDragon = false;
        boolean isWither = false;
        for (Entity e : world.func_72910_y()) {
            EntityLiving living;
            IEntityData data;
            double dist;
            if (e == player2 || !this.isApplicableType(e) || (dist = e.func_174818_b(playerPos)) > 65536.0 || e.func_82150_aj() || e.func_184191_r((Entity)player2)) continue;
            if (!e.func_184222_aU()) {
                if (e instanceof EntityWither) {
                    isBoss = true;
                    isWither = true;
                    inBattle = true;
                    isDragon = false;
                    break;
                }
                if (e instanceof EntityDragon) {
                    isBoss = true;
                    isDragon = true;
                    inBattle = true;
                    continue;
                }
                if (!(dist <= 16384.0)) continue;
                isBoss = true;
                inBattle = true;
                continue;
            }
            if (inBattle || dist > 400.0 || (data = (IEntityData)e.getCapability(CapabilityEntityData.ENTITY_DATA, null)) == null || !data.isAttacking() || !(living = (EntityLiving)e).func_70635_at().func_75522_a((Entity)player2) && !player2.func_70685_l((Entity)living)) continue;
            inBattle = true;
        }
        int tickCounter = EnvironStateHandler.EnvironState.getTickCounter();
        if (inBattle) {
            this.inBattle = inBattle;
            this.isBoss = isBoss;
            this.isWither = isWither;
            this.isDragon = isDragon;
            this.battleTimer = tickCounter + 10;
        } else if (this.inBattle && tickCounter > this.battleTimer) {
            this.reset();
        }
    }
}

