/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.scanners;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.fx.BlockEffect;
import org.orecruncher.dsurround.lib.scanner.CuboidScanner;
import org.orecruncher.dsurround.lib.scanner.ScanLocus;
import org.orecruncher.dsurround.registry.blockstate.BlockStateData;
import org.orecruncher.dsurround.registry.blockstate.BlockStateUtil;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class AlwaysOnBlockEffectScanner
extends CuboidScanner {
    protected BlockStateData profile = null;

    public AlwaysOnBlockEffectScanner(@Nonnull ScanLocus locus, int range) {
        super(locus, "AlwaysOnBlockEffectScanner", range, 0);
        this.setLogger(ModBase.log());
    }

    @Override
    protected boolean interestingBlock(IBlockState state) {
        return ((BlockStateData)BlockStateUtil.getStateData(state)).hasAlwaysOnEffects();
    }

    @Override
    public void blockScan(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        IBlockAccessEx provider = this.locus.getWorld();
        BlockEffect[] effects2 = ((BlockStateData)BlockStateUtil.getStateData(state)).getAlwaysOnEffects();
        for (int i = 0; i < effects2.length; ++i) {
            BlockEffect be = effects2[i];
            if (!be.canTrigger(provider, state, pos, rand)) continue;
            be.doEffect(provider, state, pos, rand);
        }
    }
}

